/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.util.noise.simplex.biome;

import corgiaoc.byg.util.noise.simplex.biome.OpenSimplexNoise;
import java.util.Random;

public final class OctaveOpenSimplexNoise {
    protected OpenSimplexNoise[] samplers;
    protected double clamp;
    private double inverseFrequency;

    public OctaveOpenSimplexNoise(Random rand, int octaves, double spread) {
        this.samplers = new OpenSimplexNoise[octaves];
        this.clamp = 1.0 / (1.0 - 1.0 / Math.pow(2.0, octaves));
        for (int i = 0; i < octaves; ++i) {
            this.samplers[i] = new OpenSimplexNoise(rand);
        }
        this.setSpread(spread);
    }

    private void setSpread(double stretch) {
        this.inverseFrequency = stretch * 2.0;
    }

    public double sample(double x) {
        double amplFreq = 0.5;
        double result = 0.0;
        for (OpenSimplexNoise sampler : this.samplers) {
            result += amplFreq * sampler.sample(x / (amplFreq * this.inverseFrequency));
            amplFreq *= 0.5;
        }
        return result * this.clamp;
    }

    public double sample(double x, double y) {
        double amplFreq = 0.5;
        double result = 0.0;
        for (OpenSimplexNoise sampler : this.samplers) {
            result += amplFreq * sampler.sample(x / (amplFreq * this.inverseFrequency), y / (amplFreq * this.inverseFrequency));
            amplFreq *= 0.5;
        }
        return result / 2.0 * this.clamp;
    }
}

