/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SimpleDialerTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    private GlobalPos transmitter;
    private Integer receiver;
    private boolean onceMode = false;
    private boolean prevIn = false;

    public SimpleDialerTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_SIMPLE_DIALER.get());
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void update() {
        if (this.transmitter == null) {
            return;
        }
        if (this.powerLevel > 0 == this.prevIn) {
            return;
        }
        this.prevIn = this.powerLevel > 0;
        this.func_70296_d();
        if (this.powerLevel > 0) {
            int dial;
            GlobalPos gc;
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            BlockPos coordinate = null;
            RegistryKey dim = World.field_234918_g_;
            if (this.receiver != null && (gc = destinations.getCoordinateForId(this.receiver)) != null) {
                coordinate = gc.func_218180_b();
                dim = gc.func_239646_a_();
            }
            if ((dial = TeleportationTools.dial(this.func_145831_w(), null, null, this.transmitter.func_218180_b(), (RegistryKey<World>)this.transmitter.func_239646_a_(), coordinate, (RegistryKey<World>)dim, this.onceMode)) != 0) {
                // empty if block
            }
        }
    }

    public boolean isOnceMode() {
        return this.onceMode;
    }

    public void setOnceMode(boolean onceMode) {
        this.onceMode = onceMode;
        this.func_70296_d();
    }

    public GlobalPos getTransmitter() {
        return this.transmitter;
    }

    public Integer getReceiver() {
        return this.receiver;
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        if (info.func_74764_b("transX")) {
            String transDim = info.func_74779_i("transDim");
            this.transmitter = GlobalPos.func_239648_a_((RegistryKey)LevelTools.getId((String)transDim), (BlockPos)new BlockPos(info.func_74762_e("transX"), info.func_74762_e("transY"), info.func_74762_e("transZ")));
        } else {
            this.transmitter = null;
        }
        this.receiver = info.func_74764_b("receiver") ? Integer.valueOf(info.func_74762_e("receiver")) : null;
        this.onceMode = info.func_74767_n("once");
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.transmitter != null) {
            info.func_74768_a("transX", this.transmitter.func_218180_b().func_177958_n());
            info.func_74768_a("transY", this.transmitter.func_218180_b().func_177956_o());
            info.func_74768_a("transZ", this.transmitter.func_218180_b().func_177952_p());
            info.func_74778_a("transDim", this.transmitter.func_239646_a_().func_240901_a_().toString());
        }
        if (this.receiver != null) {
            info.func_74768_a("receiver", this.receiver.intValue());
        }
        info.func_74757_a("once", this.onceMode);
    }
}

