/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.client.GuiMatterReceiver;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class MatterReceiverTileEntity
extends TickingTileEntity {
    private final Set<String> allowedPlayers = new HashSet<String>();
    private int id = -1;
    private String name = null;
    @GuiValue
    public static final Value<?, String> VALUE_NAME = Value.create((String)"name", (Type)Type.STRING, MatterReceiverTileEntity::getName, MatterReceiverTileEntity::setName);
    private boolean privateAccess = false;
    @GuiValue(name="private")
    public static final Value<?, Boolean> VALUE_PRIVATE = Value.create((String)"private", (Type)Type.BOOLEAN, MatterReceiverTileEntity::isPrivateAccess, MatterReceiverTileEntity::setPrivateAccess);
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.RECEIVER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Matter Receiver").containerSupplier(DefaultContainerProvider.empty(TeleporterModule.CONTAINER_MATTER_RECEIVER, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private BlockPos cachedPos;
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_ADDPLAYER = Command.create((String)"receiver.addPlayer", (te, player, params) -> te.addPlayer((String)params.get(PARAM_PLAYER)));
    @ServerCommand
    public static final Command<?> CMD_DELPLAYER = Command.create((String)"receiver.delPlayer", (te, player, params) -> te.delPlayer((String)params.get(PARAM_PLAYER)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETPLAYERS = ListCommand.create((String)"rftoolsutility.receiver.getPlayers", (te, player, params) -> te.getAllowedPlayers(), (te, player, params, list) -> GuiMatterReceiver.storeAllowedPlayersForClient(list));

    public MatterReceiverTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_MATTER_RECEIVER.get());
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            GlobalPos gc = GlobalPos.func_239648_a_((RegistryKey)this.field_145850_b.func_234923_W_(), (BlockPos)this.func_174877_v());
            this.id = destinations.getNewId(gc);
            destinations.save();
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.func_70296_d();
    }

    public void setName(String name) {
        this.name = name;
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination(this.func_174877_v(), (RegistryKey<World>)this.field_145850_b.func_234923_W_());
        if (destination != null) {
            destination.setName(name);
            destinations.save();
        }
        this.func_70296_d();
    }

    public void storeEnergy(long amount) {
        this.energyStorage.setEnergy(amount);
    }

    protected void tickServer() {
        if (!this.func_174877_v().equals((Object)this.cachedPos)) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            destinations.removeDestination(this.cachedPos, (RegistryKey<World>)this.field_145850_b.func_234923_W_());
            this.cachedPos = this.func_174877_v();
            GlobalPos gc = GlobalPos.func_239648_a_((RegistryKey)this.field_145850_b.func_234923_W_(), (BlockPos)this.func_174877_v());
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.addDestination(gc);
            destinations.save();
            this.func_70296_d();
        }
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.updateDestination();
        this.func_70296_d();
    }

    public TeleportDestination updateDestination() {
        GlobalPos gc;
        if (this.field_145850_b.func_201670_d()) {
            return null;
        }
        TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination((gc = GlobalPos.func_239648_a_((RegistryKey)this.field_145850_b.func_234923_W_(), (BlockPos)this.func_174877_v())).func_218180_b(), (RegistryKey<World>)gc.func_239646_a_());
        if (destination != null) {
            destination.setName(this.name);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
                this.func_70296_d();
            } else {
                destinations.assignId(gc, this.id);
            }
            destination.setPrivateAccess(this.privateAccess);
            destination.setAllowedPlayers(this.allowedPlayers);
            destinations.save();
        }
        this.func_70296_d();
        return destination;
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.updateDestination();
            this.func_70296_d();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.updateDestination();
            this.func_70296_d();
        }
    }

    public int checkStatus() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockReader)this.field_145850_b, this.func_174877_v().func_177984_a())) {
            return 1;
        }
        block = this.field_145850_b.func_180495_p(this.func_174877_v().func_177981_b(2)).func_177230_c();
        if (!block.isAir(state, (IBlockReader)this.field_145850_b, this.func_174877_v().func_177981_b(2))) {
            return 1;
        }
        if (this.getStoredPower() < (Integer)TeleportConfiguration.rfPerTeleportReceiver.get()) {
            return 16;
        }
        return 0;
    }

    private int getStoredPower() {
        return this.energyStorage.getEnergyStored();
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.cachedPos = new BlockPos(tagCompound.func_74762_e("cachedX"), tagCompound.func_74762_e("cachedY"), tagCompound.func_74762_e("cachedZ"));
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(CompoundNBT tagCompound) {
        this.energyStorage.setEnergy(tagCompound.func_74763_f("Energy"));
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.name = info.func_74779_i("tpName");
        this.privateAccess = info.func_74767_n("private");
        this.allowedPlayers.clear();
        ListNBT playerList = info.func_150295_c("players", 8);
        for (int i = 0; i < playerList.size(); ++i) {
            this.allowedPlayers.add(playerList.func_150307_f(i));
        }
        this.id = info.func_74764_b("destinationId") ? info.func_74762_e("destinationId") : -1;
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        if (this.cachedPos != null) {
            tagCompound.func_74768_a("cachedX", this.cachedPos.func_177958_n());
            tagCompound.func_74768_a("cachedY", this.cachedPos.func_177956_o());
            tagCompound.func_74768_a("cachedZ", this.cachedPos.func_177952_p());
        }
        this.writeRestorableToNBT(tagCompound);
    }

    public void writeRestorableToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74772_a("Energy", this.energyStorage.getEnergy());
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            info.func_74778_a("tpName", this.name);
        }
        info.func_74757_a("private", this.privateAccess);
        ListNBT playerTagList = new ListNBT();
        for (String player : this.allowedPlayers) {
            playerTagList.add((Object)StringNBT.func_229705_a_((String)player));
        }
        info.func_218657_a("players", (INBT)playerTagList);
        info.func_74768_a("destinationId", this.id);
    }
}

