/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationItem;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.screen.items.modules.ButtonModuleItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class RedstoneChannelBlock
extends LogicSlabBlock {
    public RedstoneChannelBlock(BlockBuilder builder) {
        super(builder);
    }

    protected static final String getChannelString(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, (info, s) -> Integer.toString(info.func_74762_e(s)), (String)"channel", (Object)"<unset>");
    }

    private boolean isRedstoneChannelItem(Item item) {
        return item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof RedstoneChannelBlock || item instanceof ButtonModuleItem || item instanceof RedstoneInformationItem;
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult result) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (this.isRedstoneChannelItem(stack.func_77973_b()) && (te = world.func_175625_s(pos)) instanceof RedstoneChannelTileEntity) {
            if (!world.field_72995_K) {
                RedstoneChannelTileEntity rcte = (RedstoneChannelTileEntity)te;
                if (stack.func_77973_b() instanceof RedstoneInformationItem) {
                    int channel = rcte.getChannel(false);
                    if (channel != -1) {
                        if (RedstoneInformationItem.addChannel(stack, channel)) {
                            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Added channel " + channel + "!"));
                        } else {
                            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Channel " + channel + " was already added!"));
                        }
                    } else {
                        Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Block has no channel yet!"));
                    }
                } else if (stack.func_77973_b() instanceof ButtonModuleItem) {
                    int channel;
                    if (!player.func_213453_ef()) {
                        channel = rcte.getChannel(true);
                        stack.func_196082_o().func_74768_a("channel", channel);
                    } else {
                        channel = ButtonModuleItem.getChannel(stack);
                        if (channel == -1) {
                            RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                            channel = redstoneChannels.newChannel();
                            redstoneChannels.save();
                            stack.func_196082_o().func_74768_a("channel", channel);
                        }
                        rcte.setChannel(channel);
                    }
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Channel set to " + channel + "!"));
                } else {
                    int channel;
                    if (!player.func_213453_ef()) {
                        channel = rcte.getChannel(true);
                        NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"channel", (Object)channel);
                    } else {
                        channel = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundNBT::func_74762_e, (String)"channel", (Object)-1);
                        if (channel == -1) {
                            RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(world);
                            channel = redstoneChannels.newChannel();
                            redstoneChannels.save();
                            NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"channel", (Object)channel);
                        }
                        rcte.setChannel(channel);
                    }
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Channel set to " + channel + "!"));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, result);
    }
}

