/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.ChargingPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.FluidPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model.FluidizerModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.screen.FluidizerSolidInjectorScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodBlockColor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorControlRodScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorFluidAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorRedstonePortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.ReactorSolidAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorIOModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model.ReprocessorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.render.ReprocessorCollectorRender;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen.ReprocessorAccessPortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen.ReprocessorControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineGlassModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineRotorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorBearingEntityRenderer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineControllerScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.screen.TurbineRedstonePortScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.extremereactors.proxy.IProxy;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.model.BlockVariantsModelBuilder;
import it.zerono.mods.zerocore.lib.client.model.ICustomModelBuilder;
import it.zerono.mods.zerocore.lib.client.model.ModBakedModelSupplier;
import it.zerono.mods.zerocore.lib.compat.Mods;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class ClientProxy
implements IProxy,
ISelectiveResourceReloadListener {
    private static final ModBakedModelSupplier s_bakedModelSupplier = new ModBakedModelSupplier();
    private final List<ICustomModelBuilder> _modelBuilders = ClientProxy.initModels();
    private Map<Item, Set<ITextComponent>> _apiTooltipCache;

    public ClientProxy() {
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        bus.register((Object)this);
        bus = (IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get();
        bus.addListener(this::onItemTooltip);
        bus.addListener(EventPriority.LOWEST, this::onVanillaTagsUpdated);
        bus.addListener(this::onTextureStitchPre);
        CodeHelper.addResourceReloadListener((ISelectiveResourceReloadListener)this);
    }

    public static Supplier<IBakedModel> getModelSupplier(ResourceLocation modelId) {
        return s_bakedModelSupplier.getOrCreate(modelId);
    }

    @SubscribeEvent
    public void onClientInit(FMLClientSetupEvent event) {
        CachedSprites.initialize();
        event.enqueueWork(() -> {
            ClientProxy.registerRenderTypes();
            ClientProxy.registerTileRenderers();
            ClientProxy.registerScreens();
            Mods.PATCHOULI.ifPresent(PatchouliCompat::initialize);
        });
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        this._modelBuilders.forEach(ICustomModelBuilder::onRegisterModels);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        this._modelBuilders.forEach(builder -> builder.onBakeModels(event));
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        event.addSprite(CachedSprites.GUI_CHARGINGPORT_SLOT_ID);
    }

    public void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)Config.CLIENT.disableApiTooltips.get()).booleanValue() && event.getFlags().func_194127_a()) {
            event.getToolTip().addAll(this.getApiTooltipCache().getOrDefault(event.getItemStack().func_77973_b(), Collections.emptySet()));
        }
    }

    @SubscribeEvent
    public void onColorHandlerEvent(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((IBlockColor)new ReactorFuelRodBlockColor(), new Block[]{(Block)Content.Blocks.REACTOR_FUELROD_BASIC.get(), (Block)Content.Blocks.REACTOR_FUELROD_REINFORCED.get()});
    }

    @Override
    public FuelRodsLayout createFuelRodsLayout(Direction direction, int length) {
        return new ClientFuelRodsLayout(direction, length);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.invalidateApiTooltipCache();
    }

    private static List<ICustomModelBuilder> initModels() {
        return (List)Streams.concat((Stream[])new Stream[]{Arrays.stream(ReactorVariant.values()).flatMap(v -> Stream.of(new ICustomModelBuilder[]{new ReactorModelBuilder((ReactorVariant)v), new ReactorGlassModelBuilder((IMultiblockReactorVariant)v), new ReactorFuelRodModelBuilder((IMultiblockReactorVariant)v)})), Arrays.stream(TurbineVariant.values()).flatMap(v -> Stream.of(new BlockVariantsModelBuilder[]{new TurbineModelBuilder((TurbineVariant)v), new TurbineGlassModelBuilder((IMultiblockTurbineVariant)v), new TurbineRotorModelBuilder((IMultiblockTurbineVariant)v)})), Stream.of(new BlockVariantsModelBuilder[]{new ReprocessorModelBuilder(), new ReprocessorIOModelBuilder(), new ReprocessorGlassModelBuilder(), new FluidizerModelBuilder(), new FluidizerGlassModelBuilder()})}).collect(ImmutableList.toImmutableList());
    }

    private static void registerScreens() {
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_CONTROLLER, ReactorControllerScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_SOLID_ACCESSPORT, ReactorSolidAccessPortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_FLUID_ACCESSPORT, ReactorFluidAccessPortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_REDSTONEPORT, ReactorRedstonePortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_CONTROLROD, ReactorControlRodScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_CHARGINGPORT, (container, inventory, title) -> new ChargingPortScreen(container, inventory, title, ExtremeReactors.newID("reactor/part-forgechargingport")));
        ClientProxy.registerScreen(Content.ContainerTypes.REACTOR_FLUIDPORT, (container, inventory, title) -> new FluidPortScreen(container, inventory, title, ExtremeReactors.newID("reactor/part-forgefluidport")));
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_CONTROLLER, TurbineControllerScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_CHARGINGPORT, (container, inventory, title) -> new ChargingPortScreen(container, inventory, title, ExtremeReactors.newID("turbine/part-forgechargingport")));
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_FLUIDPORT, (container, inventory, title) -> new FluidPortScreen(container, inventory, title, ExtremeReactors.newID("turbine/part-forgefluidport")));
        ClientProxy.registerScreen(Content.ContainerTypes.TURBINE_REDSTONEPORT, TurbineRedstonePortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REPROCESSOR_CONTROLLER, ReprocessorControllerScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.REPROCESSOR_ACCESSPORT, ReprocessorAccessPortScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.FLUIDIZER_SOLID_INJECTOR, FluidizerSolidInjectorScreen::new);
        ClientProxy.registerScreen(Content.ContainerTypes.FLUIDIZER_CONTROLLER, FluidizerControllerScreen::new);
    }

    private static void registerRenderTypes() {
        ClientProxy.registerRenderType(RenderType.func_228645_f_(), new Supplier[]{Content.Blocks.REACTOR_GLASS_BASIC, Content.Blocks.REACTOR_GLASS_REINFORCED, Content.Blocks.TURBINE_GLASS_BASIC, Content.Blocks.TURBINE_GLASS_REINFORCED, Content.Blocks.REPROCESSOR_GLASS, Content.Blocks.FLUIDIZER_GLASS});
        ClientProxy.registerRenderType(RenderType.func_228643_e_(), new Supplier[]{Content.Blocks.TURBINE_ROTORBLADE_BASIC, Content.Blocks.TURBINE_ROTORBLADE_REINFORCED, Content.Blocks.TURBINE_ROTORSHAFT_BASIC, Content.Blocks.TURBINE_ROTORSHAFT_REINFORCED});
    }

    private static void registerTileRenderers() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Content.TileEntityTypes.TURBINE_ROTORBEARING.get()), RotorBearingEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Content.TileEntityTypes.REPROCESSOR_COLLECTOR.get()), ReprocessorCollectorRender::new);
    }

    private static <M extends Container, U extends Screen> void registerScreen(Supplier<? extends ContainerType<? extends M>> type, ScreenManager.IScreenFactory<M, U> factory) {
        ScreenManager.func_216911_a(type.get(), factory);
    }

    @SafeVarargs
    private static void registerRenderType(RenderType type, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)type);
        }
    }

    private void onVanillaTagsUpdated(TagsUpdatedEvent.VanillaTagTypes event) {
        this.invalidateApiTooltipCache();
    }

    private Map<Item, Set<ITextComponent>> getApiTooltipCache() {
        if (null == this._apiTooltipCache) {
            this._apiTooltipCache = ClientProxy.buildApiTooltipCache();
        }
        return this._apiTooltipCache;
    }

    private void invalidateApiTooltipCache() {
        this._apiTooltipCache = null;
    }

    private static Map<Item, Set<ITextComponent>> buildApiTooltipCache() {
        HashMap wipCache = Maps.newHashMap();
        ReactantMappingsRegistry.fillReactantsTooltips(wipCache, (NonNullSupplier<Set<ITextComponent>>)((NonNullSupplier)Sets::newHashSet));
        ModeratorsRegistry.fillModeratorsTooltips(wipCache, (NonNullSupplier<Set<ITextComponent>>)((NonNullSupplier)Sets::newHashSet));
        CoilMaterialRegistry.fillModeratorsTooltips(wipCache, (NonNullSupplier<Set<ITextComponent>>)((NonNullSupplier)Sets::newHashSet));
        return new Object2ObjectArrayMap((Map)wipCache);
    }
}

