/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.TwoToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.AbstractTwoToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.serializer.TwoToOneRecipeSerializer;
import java.util.function.IntFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidizerSolidMixingRecipe
extends AbstractTwoToOneRecipe<ItemStack, ItemStack, FluidStack, ItemStackRecipeIngredient, ItemStackRecipeIngredient, FluidStackRecipeResult>
implements IFluidizerRecipe {
    private static final String[] LABELS = new String[]{"ingredient1", "ingredient2"};
    private static final IntFunction<String> JSON_LABELS_SUPPLIER = n -> LABELS[n];
    private static long s_maxResultAmount = 0L;

    protected FluidizerSolidMixingRecipe(ResourceLocation id, ItemStackRecipeIngredient ingredient1, ItemStackRecipeIngredient ingredient2, FluidStackRecipeResult result) {
        super(id, (IRecipeIngredient)ingredient1, (IRecipeIngredient)ingredient2, (IRecipeResult)result, JSON_LABELS_SUPPLIER);
        s_maxResultAmount = Math.max(s_maxResultAmount, result.getAmount());
    }

    public static boolean lookup(ModRecipe recipe, IRecipeIngredientSource<ItemStack> source1, IRecipeIngredientSource<ItemStack> source2) {
        return recipe instanceof FluidizerSolidMixingRecipe && ((FluidizerSolidMixingRecipe)recipe).test(source1.getIngredient(), source2.getIngredient());
    }

    public static long getMaxResultAmount() {
        return s_maxResultAmount;
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return IFluidizerRecipe.Type.SolidMixing;
    }

    public boolean match(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient1()).test((Object)stack) || ((ItemStackRecipeIngredient)this.getIngredient2()).test((Object)stack);
    }

    public boolean match(ItemStack stack1, ItemStack stack2) {
        ItemStackRecipeIngredient ingredient1 = (ItemStackRecipeIngredient)this.getIngredient1();
        ItemStackRecipeIngredient ingredient2 = (ItemStackRecipeIngredient)this.getIngredient2();
        return ingredient1.test((Object)stack1) && ingredient2.test((Object)stack2);
    }

    public boolean matchIgnoreAmount(ItemStack stack) {
        return ((ItemStackRecipeIngredient)this.getIngredient1()).testIgnoreAmount((Object)stack) || ((ItemStackRecipeIngredient)this.getIngredient2()).testIgnoreAmount((Object)stack);
    }

    public static IRecipeSerializer<FluidizerSolidMixingRecipe> serializer() {
        return new TwoToOneRecipeSerializer(FluidizerSolidMixingRecipe::new, ItemStackRecipeIngredient::from, ItemStackRecipeIngredient::from, ItemStackRecipeIngredient::from, ItemStackRecipeIngredient::from, FluidStackRecipeResult::from, FluidStackRecipeResult::from, JSON_LABELS_SUPPLIER);
    }

    public static TwoToOneRecipeBuilder<ItemStack, ItemStack, FluidStack> builder(IRecipeIngredient<ItemStack> ingredient1, IRecipeIngredient<ItemStack> ingredient2, IRecipeResult<FluidStack> result) {
        return new TwoToOneRecipeBuilder(IFluidizerRecipe.Type.SolidMixing.getRecipeId(), ingredient1, ingredient2, result, JSON_LABELS_SUPPLIER);
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this.getEnergyUsageMultiplier(((FluidStackRecipeResult)this.getResult()).getResult());
    }

    public IRecipeSerializer<FluidizerSolidMixingRecipe> func_199559_b() {
        return (IRecipeSerializer)Content.Recipes.FLUIDIZER_SOLIDMIXING_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE;
    }

    public static class HeldRecipe
    extends AbstractHeldRecipe<FluidizerSolidMixingRecipe>
    implements IFluidizerRecipe.Held<FluidizerSolidMixingRecipe> {
        private final IRecipeIngredientSource<ItemStack> _item1Source;
        private final IRecipeIngredientSource<ItemStack> _item2Source;
        private final IRecipeResultTarget<FluidStackRecipeResult> _outputTarget;

        public <Holder extends IRecipeHolder<FluidizerSolidMixingRecipe>> HeldRecipe(FluidizerSolidMixingRecipe recipe, Holder holder, IRecipeIngredientSource<ItemStack> item1Source, IRecipeIngredientSource<ItemStack> item2Source, IRecipeResultTarget<FluidStackRecipeResult> outputTarget) {
            super((ModRecipe)recipe, holder);
            this._item1Source = item1Source;
            this._item2Source = item2Source;
            this._outputTarget = outputTarget;
        }

        public void onRecipeProcessed() {
            FluidizerSolidMixingRecipe recipe = (FluidizerSolidMixingRecipe)this.getRecipe();
            ItemStack item1 = (ItemStack)this._item1Source.getMatchFrom(recipe.getIngredient1());
            ItemStack item2 = (ItemStack)this._item2Source.getMatchFrom(recipe.getIngredient2());
            if (!item1.func_190926_b() && !item2.func_190926_b()) {
                this._item1Source.consumeIngredient((Object)item1);
                this._item2Source.consumeIngredient((Object)item2);
                this._outputTarget.setResult(recipe.getResult(), OperationMode.Execute);
            }
        }
    }
}

