/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei.fluidizer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.compat.jei.AbstractModRecipeCategory;
import it.zerono.mods.zerocore.lib.compat.jei.drawable.ProgressBarDrawable;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidizerRecipeCategory
extends AbstractModRecipeCategory<ModRecipe> {
    private final Rectangle _powerBarArea;
    private final ProgressBarDrawable _powerBar;
    private final IDrawableAnimated _leftProgressBar;
    private final IDrawableAnimated _rightProgressBar;
    private final Map<Rectangle, List<ITextComponent>> _tooltips = new Object2ObjectArrayMap(4);

    public static FluidizerRecipeCategory solid(IGuiHelper guiHelper) {
        return new FluidizerRecipeCategory(IFluidizerRecipe.Type.Solid, "compat.bigreactors.jei.fluidizer.recipecategory.solid.title", guiHelper, (Supplier)Content.Blocks.FLUIDIZER_SOLIDINJECTOR){

            @Override
            public void setIngredients(ModRecipe recipe, IIngredients ingredients) {
                super.setIngredients(recipe, ingredients);
                if (recipe instanceof FluidizerSolidRecipe) {
                    FluidizerSolidRecipe solidRecipe = (FluidizerSolidRecipe)recipe;
                    ingredients.setInputs(VanillaTypes.ITEM, ((ItemStackRecipeIngredient)solidRecipe.getIngredient()).getMatchingElements());
                    ingredients.setOutput(VanillaTypes.FLUID, (Object)((FluidStackRecipeResult)solidRecipe.getResult()).getResult());
                }
            }

            public void setRecipe(IRecipeLayout layout, ModRecipe recipe, IIngredients ingredients) {
                IGuiItemStackGroup items = layout.getItemStacks();
                IGuiFluidStackGroup fluids = layout.getFluidStacks();
                items.init(0, true, 25, 46);
                items.set(ingredients);
                fluids.init(0, false, 71, 23, 16, 64, (int)FluidizerSolidRecipe.getMaxResultAmount(), true, null);
                fluids.set(ingredients);
            }

            public boolean isHandled(ModRecipe recipe) {
                return recipe instanceof FluidizerSolidRecipe;
            }
        };
    }

    public static FluidizerRecipeCategory solidMixing(IGuiHelper guiHelper) {
        return new FluidizerRecipeCategory(IFluidizerRecipe.Type.SolidMixing, "compat.bigreactors.jei.fluidizer.recipecategory.solidmixing.title", guiHelper, (Supplier)Content.Blocks.FLUIDIZER_SOLIDINJECTOR){

            @Override
            public void setIngredients(ModRecipe recipe, IIngredients ingredients) {
                super.setIngredients(recipe, ingredients);
                if (recipe instanceof FluidizerSolidMixingRecipe) {
                    FluidizerSolidMixingRecipe solidRecipe = (FluidizerSolidMixingRecipe)recipe;
                    ingredients.setInputLists(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])new List[]{((ItemStackRecipeIngredient)solidRecipe.getIngredient1()).getMatchingElements(), ((ItemStackRecipeIngredient)solidRecipe.getIngredient2()).getMatchingElements()}));
                    ingredients.setOutput(VanillaTypes.FLUID, (Object)((FluidStackRecipeResult)solidRecipe.getResult()).getResult());
                }
            }

            public void setRecipe(IRecipeLayout layout, ModRecipe recipe, IIngredients ingredients) {
                IGuiItemStackGroup items = layout.getItemStacks();
                IGuiFluidStackGroup fluids = layout.getFluidStacks();
                items.init(0, true, 25, 46);
                items.set(ingredients);
                items.init(1, true, 115, 46);
                items.set(ingredients);
                fluids.init(0, false, 71, 23, 16, 64, (int)FluidizerSolidMixingRecipe.getMaxResultAmount(), true, null);
                fluids.set(ingredients);
            }

            public boolean isHandled(ModRecipe recipe) {
                return recipe instanceof FluidizerSolidMixingRecipe;
            }
        };
    }

    public static FluidizerRecipeCategory fluidMixing(IGuiHelper guiHelper) {
        return new FluidizerRecipeCategory(IFluidizerRecipe.Type.FluidMixing, "compat.bigreactors.jei.fluidizer.recipecategory.fluidmixing.title", guiHelper, (Supplier)Content.Blocks.FLUIDIZER_FLUIDINJECTOR){

            @Override
            public void setIngredients(ModRecipe recipe, IIngredients ingredients) {
                super.setIngredients(recipe, ingredients);
                if (recipe instanceof FluidizerFluidMixingRecipe) {
                    FluidizerFluidMixingRecipe fluidRecipe = (FluidizerFluidMixingRecipe)recipe;
                    ingredients.setInputLists(VanillaTypes.FLUID, (List)Lists.newArrayList((Object[])new List[]{((FluidStackRecipeIngredient)fluidRecipe.getIngredient1()).getMatchingElements(), ((FluidStackRecipeIngredient)fluidRecipe.getIngredient2()).getMatchingElements()}));
                    ingredients.setOutput(VanillaTypes.FLUID, (Object)((FluidStackRecipeResult)fluidRecipe.getResult()).getResult());
                }
            }

            public void setRecipe(IRecipeLayout layout, ModRecipe recipe, IIngredients ingredients) {
                IGuiFluidStackGroup stacks = layout.getFluidStacks();
                stacks.init(0, true, 26, 23, 16, 64, (int)FluidizerFluidMixingRecipe.getMaxResultAmount(), true, null);
                stacks.set(ingredients);
                stacks.init(1, true, 116, 23, 16, 64, (int)FluidizerFluidMixingRecipe.getMaxResultAmount(), true, null);
                stacks.set(ingredients);
                stacks.init(2, false, 71, 23, 16, 64, (int)FluidizerFluidMixingRecipe.getMaxResultAmount(), true, null);
                stacks.set(ingredients);
            }

            public boolean isHandled(ModRecipe recipe) {
                return recipe instanceof FluidizerFluidMixingRecipe;
            }
        };
    }

    public Class<? extends ModRecipe> getRecipeClass() {
        return ModRecipe.class;
    }

    public void setIngredients(ModRecipe recipe, IIngredients ingredients) {
        if (!(recipe instanceof IFluidizerRecipe)) {
            return;
        }
        IFluidizerRecipe fluidizerRecipe = (IFluidizerRecipe)recipe;
        int energyCost = (Integer)Config.COMMON.fluidizer.energyPerRecipeTick.get() * fluidizerRecipe.getEnergyUsageMultiplier() * fluidizerRecipe.getRecipeType().getTicks();
        this._powerBar.setProgress(MultiblockFluidizer.ENERGY_CAPACITY.doubleValue(), (double)energyCost);
        this.addTooltips(this._powerBarArea, new ITextComponent[]{new TranslationTextComponent("compat.bigreactors.jei.common.recipecategory.energy.tooltip.title").func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new StringTextComponent(String.format("%d FE", energyCost)).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE)});
        FluidStack output = fluidizerRecipe.getResult().getResult();
        ingredients.setOutput(VanillaTypes.FLUID, (Object)output);
        this.addTooltips(71, 47, new ITextComponent[]{BaseHelper.getFluidNameOrEmpty((FluidStack)output).func_230530_a_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, new StringTextComponent(String.format("%d mB", output.getAmount())).func_230530_a_(CommonConstants.STYLE_TOOLTIP_VALUE)});
    }

    public void draw(ModRecipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        this._powerBar.draw(matrix, this._powerBarArea.getX1(), this._powerBarArea.getY1());
        if (null != this._leftProgressBar) {
            this._leftProgressBar.draw(matrix, 45, 47);
        }
        if (null != this._rightProgressBar) {
            this._rightProgressBar.draw(matrix, 89, 47);
        }
    }

    public List<ITextComponent> getTooltipStrings(ModRecipe recipe, double mouseX, double mouseY) {
        return this._tooltips.entrySet().stream().filter(e -> ((Rectangle)e.getKey()).contains(mouseX, mouseY)).map(Map.Entry::getValue).findAny().orElse((List)ObjectLists.emptyList());
    }

    protected FluidizerRecipeCategory(IFluidizerRecipe.Type recipeType, String titleKey, IGuiHelper guiHelper, Supplier<? extends ModBlock> iconSupplier) {
        super(recipeType.getRecipeId(), (ITextComponent)new TranslationTextComponent(titleKey), iconSupplier.get().createItemStack(), guiHelper, (IDrawable)FluidizerRecipeCategory.background(recipeType, guiHelper));
        this._powerBarArea = new Rectangle(6, 23, 16, 64);
        this._powerBar = new ProgressBarDrawable((NonNullSupplier)CommonIcons.PowerBar, 0, Padding.ZERO, this._powerBarArea.Width, this._powerBarArea.Height, Orientation.BottomToTop);
        ResourceLocation texture = ExtremeReactors.newID("textures/gui/jei/fluidizer.png");
        IDrawableStatic leftBar = guiHelper.createDrawable(texture, 0, 176, 24, 16);
        IDrawableStatic rightBar = guiHelper.createDrawable(texture, 0, 192, 24, 16);
        switch (recipeType) {
            case Solid: {
                this._leftProgressBar = guiHelper.createAnimatedDrawable(leftBar, recipeType.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
                this._rightProgressBar = null;
                break;
            }
            case SolidMixing: 
            case FluidMixing: {
                this._leftProgressBar = guiHelper.createAnimatedDrawable(leftBar, recipeType.getTicks(), IDrawableAnimated.StartDirection.LEFT, false);
                this._rightProgressBar = guiHelper.createAnimatedDrawable(rightBar, recipeType.getTicks(), IDrawableAnimated.StartDirection.RIGHT, false);
                break;
            }
            default: {
                this._rightProgressBar = null;
                this._leftProgressBar = null;
            }
        }
    }

    protected void addTooltips(int x, int y, ITextComponent ... text) {
        this.addTooltips(new Rectangle(x, y, 18, 18), text);
    }

    protected void addTooltips(Rectangle area, ITextComponent ... text) {
        this._tooltips.put(area, (List<ITextComponent>)new ObjectArrayList((Object[])text));
    }

    private static IDrawableStatic background(IFluidizerRecipe.Type recipeType, IGuiHelper guiHelper) {
        int ordinal = recipeType.ordinal() - 1;
        return guiHelper.drawableBuilder(ExtremeReactors.newID("textures/gui/jei/fluidizer.png"), 1 == ordinal ? 128 : 0, 2 == ordinal ? 88 : 0, 128, 88).addPadding(5, 5, 5, 5).build();
    }
}

