/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;

public class SlimeTreeConfig
implements IFeatureConfig {
    public static final Codec<SlimeTreeConfig> CODEC = RecordCodecBuilder.create(treeConfig -> treeConfig.group((App)BlockStateProvider.field_236796_a_.fieldOf("trunk_provider").forGetter(instance -> instance.trunkProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("leaves_provider").forGetter(instance -> instance.leavesProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("vines_provider").forGetter(instance -> instance.vinesProvider), (App)Codec.INT.fieldOf("base_height").orElse((Object)0).forGetter(instance -> instance.baseHeight), (App)Codec.INT.fieldOf("random_height").orElse((Object)0).forGetter(instance -> instance.randomHeight), (App)Codec.BOOL.fieldOf("can_double_height").orElse((Object)false).forGetter(instance -> instance.canDoubleHeight), (App)Codec.BOOL.fieldOf("has_vines").orElse((Object)false).forGetter(instance -> instance.hasVines), (App)Codec.BOOL.fieldOf("planted").orElse((Object)false).forGetter(instance -> instance.planted)).apply((Applicative)treeConfig, SlimeTreeConfig::new));
    public final BlockStateProvider trunkProvider;
    public final BlockStateProvider leavesProvider;
    public final BlockStateProvider vinesProvider;
    public final int baseHeight;
    public final int randomHeight;
    public final boolean canDoubleHeight;
    public final boolean hasVines;
    public final boolean planted;

    public SlimeTreeConfig(BlockStateProvider trunkProvider, BlockStateProvider leavesProvider, BlockStateProvider vinesProvider, int baseHeight, int randomHeight, boolean canDoubleHeight, boolean hasVines, boolean planted) {
        this.trunkProvider = trunkProvider;
        this.leavesProvider = leavesProvider;
        this.vinesProvider = vinesProvider;
        this.baseHeight = baseHeight;
        this.randomHeight = randomHeight;
        this.canDoubleHeight = canDoubleHeight;
        this.hasVines = hasVines;
        this.planted = planted;
    }

    public static class Builder {
        private static final SupplierBlockStateProvider AIR_PROVIDER = new SupplierBlockStateProvider(() -> ((Block)Blocks.field_150350_a).func_176223_P());
        private BlockStateProvider trunkProvider = AIR_PROVIDER;
        private BlockStateProvider leavesProvider = AIR_PROVIDER;
        private BlockStateProvider vinesProvider = AIR_PROVIDER;
        private int baseHeight = 5;
        private int randomHeight = 4;
        private boolean canDoubleHeight = false;
        private boolean hasVines = false;
        private boolean planted = false;

        public Builder canDoubleHeight() {
            this.canDoubleHeight = true;
            return this;
        }

        public Builder trunk(Supplier<BlockState> supplier) {
            return this.trunkProvider(new SupplierBlockStateProvider(supplier));
        }

        public Builder leaves(Supplier<BlockState> supplier) {
            return this.leavesProvider(new SupplierBlockStateProvider(supplier));
        }

        public Builder vinesProvider(SupplierBlockStateProvider supplier) {
            this.vinesProvider = supplier;
            this.hasVines = true;
            return this;
        }

        public Builder vines(Supplier<BlockState> supplier) {
            return this.vinesProvider(new SupplierBlockStateProvider(supplier));
        }

        public Builder planted() {
            this.planted = true;
            return this;
        }

        public SlimeTreeConfig build() {
            return new SlimeTreeConfig(this.trunkProvider, this.leavesProvider, this.vinesProvider, this.baseHeight, this.randomHeight, this.canDoubleHeight, this.hasVines, this.planted);
        }

        public Builder trunkProvider(BlockStateProvider trunkProvider) {
            this.trunkProvider = trunkProvider;
            return this;
        }

        public Builder leavesProvider(BlockStateProvider leavesProvider) {
            this.leavesProvider = leavesProvider;
            return this;
        }

        public Builder baseHeight(int baseHeight) {
            this.baseHeight = baseHeight;
            return this;
        }

        public Builder randomHeight(int randomHeight) {
            this.randomHeight = randomHeight;
            return this;
        }
    }
}

