/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class StickyModifier
extends IncrementalModifier {
    public StickyModifier() {
        super(0xFFFFFF);
    }

    private static EffectInstance getEffect(float scaledLevel) {
        int duration = 20;
        int maxBonus = (int)(10.0f * scaledLevel);
        if (maxBonus > 0) {
            duration += RANDOM.nextInt(maxBonus);
        }
        return new EffectInstance(Effects.field_76421_d, duration, Math.round(scaledLevel));
    }

    @Override
    public void onAttacked(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.func_76346_g();
        if (isDirectDamage && attacker instanceof LivingEntity) {
            float scaledLevel = this.getScaledLevel(tool, level);
            if (RANDOM.nextFloat() < scaledLevel * 0.25f) {
                ((LivingEntity)attacker).func_195064_c(StickyModifier.getEffect(scaledLevel));
                ToolDamageUtil.damageAnimated(tool, 1, context.getEntity(), slotType);
            }
        }
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            target.func_195064_c(StickyModifier.getEffect(this.getScaledLevel(tool, level)));
        }
        return 0;
    }
}

