/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class SpringyModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<SlotInCharge> SLOT_IN_CHARGE = TConstruct.createKey("springy");

    public SpringyModifier() {
        super(16749837);
    }

    @Override
    public void onAttacked(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity user = context.getEntity();
        Entity attacker = source.func_76346_g();
        if (isDirectDamage && !user.func_130014_f_().field_72995_K && attacker instanceof LivingEntity) {
            user.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                if (Optional.ofNullable(data.get(SLOT_IN_CHARGE)).filter(slot -> slot.inCharge == slotType).isPresent()) {
                    float bestBonus = 0.0f;
                    for (EquipmentSlotType bouncingSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                        float newBonus;
                        IModifierToolStack bouncingTool = context.getToolInSlot(bouncingSlot);
                        if (bouncingTool == null || bouncingTool.isBroken() || !(RANDOM.nextFloat() < (float)level * 0.25f) || !((newBonus = 0.5f * RANDOM.nextFloat() * (float)level) > bestBonus)) continue;
                        bestBonus = newBonus;
                    }
                    if (bestBonus > 0.0f) {
                        ((LivingEntity)attacker).func_233627_a_(bestBonus, (double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f))), (double)MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)));
                    }
                }
            });
        }
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        EquipmentSlotType slot = context.getChangedSlot();
        if (!tool.isBroken() && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !context.getEntity().func_130014_f_().field_72995_K) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(SLOT_IN_CHARGE);
                if (slotInCharge != null) {
                    slotInCharge.removeSlot(slot);
                }
            });
        }
    }

    @Override
    public void onEquip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        EquipmentSlotType slot = context.getChangedSlot();
        if (!tool.isBroken() && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !context.getEntity().func_130014_f_().field_72995_K) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(SLOT_IN_CHARGE);
                if (slotInCharge == null) {
                    slotInCharge = new SlotInCharge();
                    data.put(SLOT_IN_CHARGE, slotInCharge);
                }
                slotInCharge.addSlot(slot);
            });
        }
    }

    @Override
    public float beforeEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback + (float)level * 0.5f;
    }

    private static class SlotInCharge {
        private final boolean[] active = new boolean[4];
        @Nullable
        EquipmentSlotType inCharge = null;

        private SlotInCharge() {
        }

        void addSlot(EquipmentSlotType slotType) {
            this.active[slotType.func_188454_b()] = true;
            if (this.inCharge == null) {
                this.inCharge = slotType;
            }
        }

        void removeSlot(EquipmentSlotType slotType) {
            this.active[slotType.func_188454_b()] = false;
            for (EquipmentSlotType armorSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                if (!this.active[slotType.func_188454_b()]) continue;
                this.inCharge = armorSlot;
                break;
            }
            this.inCharge = null;
        }
    }
}

