/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class ChrysophiliteModifier
extends SingleUseModifier {
    public static final TinkerDataCapability.ComputableDataKey<TotalGold> TOTAL_GOLD = TConstruct.createKey("chrysophilite", TotalGold::new);

    public ChrysophiliteModifier() {
        super(15245428);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingDropsEvent.class, ChrysophiliteModifier::onLivingDrops);
    }

    @Override
    public void onEquip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlotType.HEAD) {
            context.getTinkerData().ifPresent(data -> {
                TotalGold gold = data.get(TOTAL_GOLD);
                if (gold == null) {
                    ((TotalGold)data.computeIfAbsent(TOTAL_GOLD)).initialize(context);
                } else {
                    gold.setGold(EquipmentSlotType.HEAD, tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL));
                }
            });
        }
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        IModifierToolStack newTool;
        if (context.getChangedSlot() == EquipmentSlotType.HEAD && ((newTool = context.getReplacementTool()) == null || newTool.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> data.remove(TOTAL_GOLD));
        }
    }

    @Override
    public void onEquipmentChange(IModifierToolStack tool, int level, EquipmentChangeContext context, EquipmentSlotType slotType) {
        EquipmentSlotType changed = context.getChangedSlot();
        if (slotType == EquipmentSlotType.HEAD && changed.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            boolean hasGold = ChrysophiliteModifier.hasGold(context, changed);
            context.getTinkerData().ifPresent(data -> ((TotalGold)data.computeIfAbsent(TOTAL_GOLD)).setGold(changed, hasGold));
        }
    }

    public static boolean hasGold(EquipmentChangeContext context, EquipmentSlotType slotType) {
        IModifierToolStack tool = context.getToolInSlot(slotType);
        if (tool != null) {
            return tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL);
        }
        LivingEntity living = context.getEntity();
        return living.func_184582_a(slotType).makesPiglinsNeutral(living);
    }

    public static int getTotalGold(@Nullable Entity entity) {
        return Optional.ofNullable(entity).flatMap(e -> e.getCapability(TinkerDataCapability.CAPABILITY).resolve()).map(data -> data.get(TOTAL_GOLD)).map(TotalGold::getTotalGold).orElse(0);
    }

    private static void onLivingDrops(LivingDropsEvent event) {
        int gold;
        DamageSource source = event.getSource();
        if (source != null && (gold = ChrysophiliteModifier.getTotalGold(source.func_76346_g())) > 0) {
            float extraChance = 0.04f * (float)gold;
            LivingEntity target = event.getEntityLiving();
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack = target.func_184582_a(slot);
                Random random = target.func_70681_au();
                if (stack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)stack) || !stack.makesPiglinsNeutral(target) || !(random.nextFloat() < extraChance)) continue;
                if (stack.func_77984_f()) {
                    stack.func_196085_b(stack.func_77958_k() - random.nextInt(1 + random.nextInt(Math.max(stack.func_77958_k() - 3, 1))));
                }
                event.getDrops().add(target.func_199701_a_(stack));
                target.func_184201_a(slot, ItemStack.field_190927_a);
            }
        }
    }

    public static class TotalGold {
        private final boolean[] hasGold = new boolean[4];
        private int totalGold = 0;

        protected boolean setGold(EquipmentSlotType slotType, boolean value) {
            int index;
            if (slotType.func_188453_a() == EquipmentSlotType.Group.ARMOR && this.hasGold[index = slotType.func_188454_b()] != value) {
                this.hasGold[index] = value;
                this.totalGold = value ? ++this.totalGold : --this.totalGold;
                return true;
            }
            return false;
        }

        public void initialize(EquipmentChangeContext context) {
            this.totalGold = 1;
            for (EquipmentSlotType slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                boolean gold;
                this.hasGold[slotType.func_188454_b()] = gold = ChrysophiliteModifier.hasGold(context, slotType);
                if (!gold) continue;
                ++this.totalGold;
            }
        }

        public int getTotalGold() {
            return this.totalGold;
        }
    }
}

