/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.TravelersGearModel;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class TravelersGearItem
extends ModifiableArmorItem {
    private static final String GOLDEN_ARMOR = TConstruct.resourceString("textures/models/armor/travelers_golden_1.png");
    private static final String GOLDEN_LEGS = TConstruct.resourceString("textures/models/armor/travelers_golden_2.png");

    public TravelersGearItem(ModifiableArmorMaterial material, ArmorSlotType slotType, Item.Properties properties) {
        super(material, slotType, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (ModifierUtil.getModifierLevel(stack, (Modifier)TinkerModifiers.golden.get()) > 0) {
            return slot == EquipmentSlotType.LEGS ? GOLDEN_LEGS : GOLDEN_ARMOR;
        }
        return null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A base) {
        return TravelersGearModel.getModel(stack, armorSlot, base);
    }
}

