/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import java.util.function.IntFunction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.Util;

public class TierToolStat
implements IToolStat<TierBuilder> {
    private final ToolStatId name;
    private final int defaultValue;
    private final IntFunction<ITextComponent> displayName;

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public float clamp(float value) {
        return MathHelper.func_76131_a((float)value, (float)0.0f, (float)2.1474836E9f);
    }

    @Override
    public TierBuilder makeBuilder() {
        return new TierBuilder();
    }

    public void set(ModifierStatsBuilder builder, int value) {
        builder.updateStat(this, b -> ((TierBuilder)b).tier = Math.max(((TierBuilder)b).tier, value));
    }

    @Override
    public void applyBonus(ModifierStatsBuilder builder, double value) {
        this.set(builder, (int)value);
    }

    @Override
    public float build(TierBuilder builder, float value) {
        return Math.max(value, (float)builder.tier);
    }

    @Override
    public ITextComponent formatValue(float number) {
        return new TranslationTextComponent(Util.makeTranslationKey("tool_stat", this.getName())).func_230529_a_(this.displayName.apply((int)number));
    }

    public String toString() {
        return "TierToolStat{" + (Object)((Object)this.name) + '}';
    }

    public TierToolStat(ToolStatId name, int defaultValue, IntFunction<ITextComponent> displayName) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.displayName = displayName;
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    protected static class TierBuilder {
        private int tier = 0;

        protected TierBuilder() {
        }
    }
}

