/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Predicate;
import net.minecraft.util.JSONUtils;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class StatPredicate
implements Predicate<StatsNBT> {
    private final IToolStat<?> stat;
    private final float min;
    private final float max;

    public static StatPredicate match(IToolStat<?> stat, float value) {
        return StatPredicate.of(stat, value, value);
    }

    public static StatPredicate min(IToolStat<?> stat, float min) {
        return StatPredicate.of(stat, min, Float.POSITIVE_INFINITY);
    }

    public static StatPredicate max(IToolStat<?> stat, float max) {
        return StatPredicate.of(stat, Float.NEGATIVE_INFINITY, max);
    }

    @Override
    public boolean test(StatsNBT statsNBT) {
        float value = statsNBT.getFloat(this.stat);
        return value >= this.min && value <= this.max;
    }

    public static StatPredicate deserialize(JsonObject json) {
        ToolStatId id = new ToolStatId(JSONUtils.func_151200_h((JsonObject)json, (String)"stat"));
        IToolStat<?> stat = ToolStats.getToolStat(id);
        if (stat == null) {
            throw new JsonSyntaxException("Unknown tool stat '" + (Object)((Object)id) + "'");
        }
        return new StatPredicate(stat, JSONUtils.func_151221_a((JsonObject)json, (String)"min", (float)Float.NEGATIVE_INFINITY), JSONUtils.func_151221_a((JsonObject)json, (String)"max", (float)Float.NEGATIVE_INFINITY));
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("stat", this.stat.getName().toString());
        if (this.min > Float.NEGATIVE_INFINITY) {
            json.addProperty("min", (Number)Float.valueOf(this.min));
        }
        if (this.max < Float.POSITIVE_INFINITY) {
            json.addProperty("max", (Number)Float.valueOf(this.max));
        }
        return json;
    }

    private StatPredicate(IToolStat<?> stat, float min, float max) {
        this.stat = stat;
        this.min = min;
        this.max = max;
    }

    public static StatPredicate of(IToolStat<?> stat, float min, float max) {
        return new StatPredicate(stat, min, max);
    }
}

