/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ToolDamageUtil {
    public static void breakTool(ItemStack stack) {
        stack.func_196082_o().func_74757_a("tic_broken", true);
    }

    public static boolean isBroken(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n("tic_broken");
    }

    @Deprecated
    public static int getCurrentDurability(ItemStack stack) {
        if (ToolDamageUtil.isBroken(stack)) {
            return 0;
        }
        return stack.func_77958_k() - stack.func_77952_i();
    }

    @Deprecated
    public static int getCurrentDamage(ItemStack stack) {
        if (ToolDamageUtil.isBroken(stack)) {
            return stack.func_77958_k();
        }
        return stack.func_77952_i();
    }

    public static boolean needsRepair(ItemStack stack) {
        return stack.func_77952_i() > 0 || ToolDamageUtil.isBroken(stack);
    }

    public static boolean directDamage(IModifierToolStack tool, int amount, @Nullable LivingEntity entity, @Nullable ItemStack stack) {
        int damage;
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_()) {
            return false;
        }
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        int current = durability - (damage = tool.getDamage());
        if ((amount = Math.min(amount, current)) > 0) {
            int newDamage = damage + amount;
            if (entity instanceof ServerPlayerEntity) {
                if (stack == null) {
                    stack = entity.func_184614_ca();
                }
                CriteriaTriggers.field_193132_s.func_193158_a((ServerPlayerEntity)entity, stack, newDamage);
            }
            tool.setDamage(newDamage);
            return newDamage >= durability;
        }
        return false;
    }

    public static boolean damage(IModifierToolStack tool, int amount, @Nullable LivingEntity entity, @Nullable ItemStack stack) {
        if (amount <= 0 || tool.isBroken() || tool.isUnbreakable()) {
            return false;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            amount = entry.getModifier().onDamageTool(tool, entry.getLevel(), amount, entity);
            if (amount >= 0) continue;
            return false;
        }
        return ToolDamageUtil.directDamage(tool, amount, entity, stack);
    }

    public static boolean damageAnimated(IModifierToolStack tool, int amount, LivingEntity entity, EquipmentSlotType slot) {
        if (ToolDamageUtil.damage(tool, amount, entity, entity.func_184582_a(slot))) {
            entity.func_213361_c(slot);
            return true;
        }
        return false;
    }

    public static boolean damageAnimated(IModifierToolStack tool, int amount, LivingEntity entity, Hand hand) {
        if (ToolDamageUtil.damage(tool, amount, entity, entity.func_184586_b(hand))) {
            entity.func_213334_d(hand);
            return true;
        }
        return false;
    }

    public static boolean damageAnimated(IModifierToolStack tool, int amount, LivingEntity entity) {
        return ToolDamageUtil.damageAnimated(tool, amount, entity, Hand.MAIN_HAND);
    }

    public static void repair(IModifierToolStack tool, int amount) {
        if (amount <= 0) {
            return;
        }
        int damage = tool.getDamage();
        if (damage == 0) {
            return;
        }
        int newDamage = damage - Math.min(amount, damage);
        tool.setDamage(newDamage);
    }

    public static boolean showDurabilityBar(ItemStack stack) {
        if (!stack.func_77973_b().func_77645_m()) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            Boolean show = entry.getModifier().showDurabilityBar(tool, entry.getLevel());
            if (show == null) continue;
            return show;
        }
        return tool.getDamage() > 0;
    }

    private static double getDamagePercentage(ToolStack tool) {
        for (ModifierEntry entry : tool.getModifierList()) {
            double display = entry.getModifier().getDamagePercentage(tool, entry.getLevel());
            if (Double.isNaN(display)) continue;
            return display;
        }
        return (double)tool.getDamage() / (double)tool.getStats().getInt(ToolStats.DURABILITY);
    }

    public static double getDamageForDisplay(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return 1.0;
        }
        return 0.95 * ToolDamageUtil.getDamagePercentage(tool);
    }

    public static int getRGBDurabilityForDisplay(ItemStack stack) {
        ToolStack tool = ToolStack.from(stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            int rgb = entry.getModifier().getDurabilityRGB(tool, entry.getLevel());
            if (rgb == -1) continue;
            return rgb;
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - ToolDamageUtil.getDamagePercentage(tool))) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

