/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    private static final ValidatedResult AT_CAPACITY = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "overslime.at_capacity"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final int restoreAmount;
    private static final Lazy<ModifierEntry> RESULT = Lazy.of(() -> new ModifierEntry((Modifier)TinkerModifiers.overslime.get(), 1));
    private static final Lazy<List<ItemStack>> DISPLAY_TOOLS = Lazy.of(() -> TinkerTags.Items.DURABILITY.func_230236_b_().stream().map(MAP_TOOL_FOR_RENDERING).collect(Collectors.toList()));
    private List<ItemStack> toolWithModifier = null;
    private List<List<ItemStack>> displayItems = null;

    public OverslimeModifierRecipe(ResourceLocation id, Ingredient ingredient, int restoreAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
        ModifierRecipeLookup.addIngredient(ingredient);
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!TinkerTags.Items.DURABILITY.func_230235_a_((Object)inv.getTinkerableStack().func_77973_b())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ItemStack tinkerable = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(tinkerable);
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getUpgrades().getLevel((Modifier)TinkerModifiers.overslime.get()) == 0) {
            if (tool.getModifierLevel((Modifier)TinkerModifiers.overslime.get()) > 0 && overslime.getOverslime(tool) >= overslime.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
            tool.addModifier((Modifier)TinkerModifiers.overslime.get(), 1);
        } else {
            if (overslime.getOverslime(tool) >= overslime.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.restoreAmount);
        overslime.addOverslime(tool, available);
        return ValidatedResult.success(tool.createStack(Math.min(tinkerable.func_190916_E(), this.shrinkToolSlotBy())));
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int current = 0;
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (tool.getModifierLevel((Modifier)TinkerModifiers.overslime.get()) != 0) {
            current = overslime.getOverslime(tool);
        }
        int maxNeeded = overslime.getOverslime(ToolStack.from(result)) - current;
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, maxNeeded, this.restoreAmount, ItemStack.field_190927_a);
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.overslimeSerializer.get();
    }

    @Override
    public List<List<ItemStack>> getDisplayItems() {
        if (this.displayItems == null) {
            this.displayItems = Arrays.asList((List)DISPLAY_TOOLS.get(), Arrays.asList(this.ingredient.func_193365_a()));
        }
        return this.displayItems;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            this.toolWithModifier = TinkerTags.Items.DURABILITY.func_230236_b_().stream().map(MAP_TOOL_FOR_RENDERING).map(stack -> IDisplayModifierRecipe.withModifiers(stack, null, (ModifierEntry)RESULT.get(), data -> overslime.setOverslime((ModDataNBT)data, this.restoreAmount))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return (ModifierEntry)RESULT.get();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<OverslimeModifierRecipe> {
        public OverslimeModifierRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            int restoreAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"restore_amount");
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        @Override
        @Nullable
        protected OverslimeModifierRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int restoreAmount = buffer.func_150792_a();
            return new OverslimeModifierRecipe(id, ingredient, restoreAmount);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, OverslimeModifierRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150787_b(recipe.restoreAmount);
        }
    }
}

