/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.container;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public abstract class ContainerFillingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    protected final IRecipeType<?> type;
    protected final ResourceLocation id;
    protected final String group;
    protected final int fluidAmount;
    protected final Item container;
    private List<DisplayCastingRecipe> displayRecipes = null;

    @Override
    public int getFluidAmount(ICastingInventory inv) {
        Fluid fluid = inv.getFluid();
        return inv.getStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> handler.fill(new FluidStack(fluid, this.fluidAmount), IFluidHandler.FluidAction.SIMULATE)).orElse(0);
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingInventory inv) {
        return 5;
    }

    public boolean matches(ICastingInventory inv, World worldIn) {
        ItemStack stack = inv.getStack();
        Fluid fluid = inv.getFluid();
        return stack.func_77973_b() == this.container.func_199767_j() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).filter(handler -> handler.fill(new FluidStack(fluid, this.fluidAmount), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.container);
    }

    public ItemStack getCraftingResult(ICastingInventory inv) {
        ItemStack stack = inv.getStack().func_77946_l();
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            handler.fill(new FluidStack(inv.getFluid(), this.fluidAmount, inv.getFluidTag()), IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(stack);
    }

    public List<DisplayCastingRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<ItemStack> casts = Collections.singletonList(new ItemStack((IItemProvider)this.container));
            this.displayRecipes = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> fluid.func_204524_b() != Items.field_190931_a && fluid.func_207193_c(fluid.func_207188_f())).map(fluid -> {
                FluidStack fluidStack = new FluidStack(fluid, this.fluidAmount);
                ItemStack stack = new ItemStack((IItemProvider)this.container);
                stack = FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                    handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    return handler.getContainer();
                }).orElse(stack);
                return new DisplayCastingRecipe(this.func_222127_g(), casts, Collections.singletonList(fluidStack), stack, 5, true);
            }).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    public ContainerFillingRecipe(IRecipeType<?> type, ResourceLocation id, String group, int fluidAmount, Item container) {
        this.type = type;
        this.id = id;
        this.group = group;
        this.fluidAmount = fluidAmount;
        this.container = container;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public Item getContainer() {
        return this.container;
    }

    public static class Table
    extends ContainerFillingRecipe {
        public Table(ResourceLocation idIn, String groupIn, int fluidAmount, Item containerIn) {
            super(RecipeTypes.CASTING_TABLE, idIn, groupIn, fluidAmount, containerIn);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.tableFillingRecipeSerializer.get();
        }
    }

    public static class Basin
    extends ContainerFillingRecipe {
        public Basin(ResourceLocation idIn, String groupIn, int fluidAmount, Item containerIn) {
            super(RecipeTypes.CASTING_BASIN, idIn, groupIn, fluidAmount, containerIn);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.basinFillingRecipeSerializer.get();
        }
    }
}

