/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.traits;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.traits.MaterialTraits;

public class UpdateMaterialTraitsPacket
implements IThreadsafePacket {
    protected final Map<MaterialId, MaterialTraits> materialToTraits;

    public UpdateMaterialTraitsPacket(PacketBuffer buffer) {
        int materialCount = buffer.readInt();
        this.materialToTraits = new HashMap<MaterialId, MaterialTraits>(materialCount);
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id = new MaterialId(buffer.func_192575_l());
            MaterialTraits traits = MaterialTraits.read(buffer);
            this.materialToTraits.put(id, traits);
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.materialToTraits.size());
        this.materialToTraits.forEach((materialId, traits) -> {
            buffer.func_192572_a((ResourceLocation)materialId);
            traits.write(buffer);
        });
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        MaterialRegistry.updateMaterialTraitsFromServer(this);
    }

    public Map<MaterialId, MaterialTraits> getMaterialToTraits() {
        return this.materialToTraits;
    }

    public UpdateMaterialTraitsPacket(Map<MaterialId, MaterialTraits> materialToTraits) {
        this.materialToTraits = materialToTraits;
    }
}

