/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ResourceLocationSerializer<T extends ResourceLocation>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    private final Function<String, T> constructor;
    private final String modId;

    public static ResourceLocationSerializer<ResourceLocation> resourceLocation(String modId) {
        return new ResourceLocationSerializer<ResourceLocation>(ResourceLocation::new, modId);
    }

    public JsonElement serialize(ResourceLocation loc, Type type, JsonSerializationContext context) {
        return new JsonPrimitive(loc.toString());
    }

    public T deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        String loc = JSONUtils.func_151206_a((JsonElement)element, (String)"location");
        if (!loc.contains(":")) {
            loc = this.modId + ":" + loc;
        }
        return (T)((ResourceLocation)this.constructor.apply(loc));
    }

    public ResourceLocationSerializer(Function<String, T> constructor, String modId) {
        this.constructor = constructor;
        this.modId = modId;
    }
}

