/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.vector.TransformationMatrix;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class BreakableDyedModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        RenderMaterial smallTexture = (RenderMaterial)smallGetter.apply("");
        RenderMaterial brokenSmall = (RenderMaterial)smallGetter.apply("_broken");
        RenderMaterial largeTexture = (RenderMaterial)largeGetter.apply("");
        RenderMaterial brokenLarge = (RenderMaterial)largeGetter.apply("_broken");
        if (smallTexture != null || brokenSmall != null || largeTexture != null || brokenLarge != null) {
            return new BreakableDyedModifierModel(smallTexture, brokenSmall, largeTexture, brokenLarge);
        }
        return null;
    };
    private final RenderMaterial[] textures;

    public BreakableDyedModifierModel(@Nullable RenderMaterial normalSmall, @Nullable RenderMaterial brokenSmall, @Nullable RenderMaterial normalLarge, @Nullable RenderMaterial brokenLarge) {
        this.textures = new RenderMaterial[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    @Override
    @Nullable
    public Object getCacheKey(IModifierToolStack tool, ModifierEntry entry) {
        Modifier modifier = entry.getModifier();
        ModifierId key = modifier.getId();
        ModDataNBT data = tool.getPersistentData();
        int color = -1;
        if (data.contains(key, 3)) {
            color = data.getInt(modifier.getId());
        }
        return new CacheKey(modifier, color);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry modifier, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge) {
        return this.getQuads(tool, modifier, spriteGetter, transforms, isLarge, -1, null);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry modifier, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        ModifierId key;
        ModDataNBT data;
        RenderMaterial texture = this.textures[(isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0)];
        if (texture != null && (data = tool.getPersistentData()).contains(key = modifier.getModifier().getId(), 3)) {
            return MantleItemLayerModel.getQuadsForSprite((int)(0xFF000000 | data.getInt(key)), (int)-1, (TextureAtlasSprite)spriteGetter.apply(texture), (TransformationMatrix)transforms, (int)0, (ItemLayerPixels)pixels);
        }
        return ImmutableList.of();
    }

    private static class CacheKey {
        private final Modifier modifier;
        private final int color;

        public CacheKey(Modifier modifier, int color) {
            this.modifier = modifier;
            this.color = color;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public int getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Modifier this$modifier = this.getModifier();
            Modifier other$modifier = other.getModifier();
            if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
                return false;
            }
            return this.getColor() == other.getColor();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Modifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
            result = result * 59 + this.getColor();
            return result;
        }

        public String toString() {
            return "BreakableDyedModifierModel.CacheKey(modifier=" + this.getModifier() + ", color=" + this.getColor() + ")";
        }
    }
}

