/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;
import slimeknights.tconstruct.library.TinkerRegistries;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class ToolModel
implements IModelGeometry<ToolModel> {
    private static final Logger log = LogManager.getLogger(ToolModel.class);
    public static final Loader LOADER = new Loader();
    public static final IItemColor COLOR_HANDLER = (stack, index) -> {
        IBakedModel itemModel;
        if (index >= 0 && (itemModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199312_b(stack.func_77973_b())) != null && itemModel.func_188617_f() instanceof MaterialOverrideHandler) {
            MaterialOverrideHandler overrides = (MaterialOverrideHandler)itemModel.func_188617_f();
            ToolStack tool = ToolStack.from(stack);
            int localIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            for (int i = modifiers.size() - 1; i >= 0; --i) {
                ModifierEntry entry = modifiers.get(i);
                IBakedModifierModel modifierModel = overrides.getModifierModel(entry.getModifier());
                if (modifierModel == null) continue;
                int modelIndexes = modifierModel.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return modifierModel.getTint(tool, entry, index - localIndex);
                }
                localIndex += modelIndexes;
            }
        }
        return -1;
    };
    private final List<ToolPart> toolParts;
    private final boolean isLarge;
    private final Vector2f offset;
    private final List<ResourceLocation> smallModifierRoots;
    private final List<ResourceLocation> largeModifierRoots;
    private final List<Modifier> firstModifiers;
    private Map<Modifier, IBakedModifierModel> modifierModels = Collections.emptyMap();

    public static void registerItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        colors.func_199877_a(COLOR_HANDLER, new IItemProvider[]{item.get()});
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures;
        block6: {
            block5: {
                allTextures = Sets.newHashSet();
                if (!this.toolParts.isEmpty()) break block5;
                allTextures.add(owner.resolveTexture("tool"));
                if (owner.isTexturePresent("broken")) {
                    allTextures.add(owner.resolveTexture("broken"));
                }
                if (!this.isLarge) break block6;
                allTextures.add(owner.resolveTexture("tool_large"));
                if (!owner.isTexturePresent("broken_large")) break block6;
                allTextures.add(owner.resolveTexture("broken_large"));
                break block6;
            }
            for (ToolPart part : this.toolParts) {
                if (part.hasMaterials()) {
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, false), null);
                    if (part.hasBroken()) {
                        MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, false), null);
                    }
                    if (!this.isLarge) continue;
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, true), null);
                    if (!part.hasBroken()) continue;
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, true), null);
                    continue;
                }
                allTextures.add(owner.resolveTexture(part.getName(false, false)));
                if (part.hasBroken()) {
                    allTextures.add(owner.resolveTexture(part.getName(true, false)));
                }
                if (!this.isLarge) continue;
                allTextures.add(owner.resolveTexture(part.getName(false, true)));
                if (!part.hasBroken()) continue;
                allTextures.add(owner.resolveTexture(part.getName(true, true)));
            }
        }
        this.modifierModels = ModifierModelManager.getModelsForTool(this.smallModifierRoots, this.isLarge ? this.largeModifierRoots : Collections.emptyList(), allTextures);
        return allTextures;
    }

    private static void addModifierQuads(Function<RenderMaterial, TextureAtlasSprite> spriteGetter, Map<Modifier, IBakedModifierModel> modifierModels, List<Modifier> firstModifiers, IModifierToolStack tool, Consumer<ImmutableList<BakedQuad>> quadConsumer, ItemLayerPixels pixels, TransformationMatrix transforms, boolean isLarge) {
        if (!modifierModels.isEmpty()) {
            int modelIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            if (!modifiers.isEmpty()) {
                int i;
                FirstModifier[] firsts = new FirstModifier[firstModifiers.size()];
                for (i = modifiers.size() - 1; i >= 0; --i) {
                    ModifierEntry entry = modifiers.get(i);
                    Modifier modifier = entry.getModifier();
                    IBakedModifierModel model = modifierModels.get(modifier);
                    if (model == null) continue;
                    int index = firstModifiers.indexOf(modifier);
                    if (index == -1) {
                        quadConsumer.accept(model.getQuads(tool, entry, spriteGetter, transforms, isLarge, modelIndex, pixels));
                    } else {
                        firsts[index] = new FirstModifier(entry, model, modelIndex);
                    }
                    modelIndex += model.getTintIndexes();
                }
                for (i = firsts.length - 1; i >= 0; --i) {
                    FirstModifier first = firsts[i];
                    if (first == null) continue;
                    quadConsumer.accept(first.model.getQuads(tool, first.entry, spriteGetter, transforms, isLarge, first.modelIndex, pixels));
                }
            }
        }
    }

    private static IBakedModel bakeInternal(IModelConfiguration owner, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, @Nullable TransformationMatrix largeTransforms, List<ToolPart> parts, Map<Modifier, IBakedModifierModel> modifierModels, List<Modifier> firstModifiers, List<MaterialId> materials, @Nullable IModifierToolStack tool, ItemOverrideList overrides) {
        boolean isBroken = tool != null && tool.isBroken();
        TextureAtlasSprite particle = null;
        ReversedListBuilder smallBuilder = new ReversedListBuilder();
        ReversedListBuilder largeBuilder = new ReversedListBuilder();
        ItemLayerPixels smallPixels = new ItemLayerPixels();
        ItemLayerPixels largePixels = new ItemLayerPixels();
        Consumer<ImmutableList<BakedQuad>> largeConsumer = arg_0 -> ((ReversedListBuilder)largeBuilder).addAll(arg_0);
        Consumer<Object> smallConsumer = largeTransforms != null ? quads -> smallBuilder.addAll((Collection)quads.stream().filter(quad -> quad.func_178210_d() == Direction.SOUTH).collect(Collectors.toList())) : arg_0 -> ((ReversedListBuilder)smallBuilder).addAll(arg_0);
        if (tool != null && !modifierModels.isEmpty()) {
            ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, smallConsumer, smallPixels, TransformationMatrix.func_227983_a_(), false);
            if (largeTransforms != null) {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, largeConsumer, largePixels, largeTransforms, true);
            }
        }
        if (parts.isEmpty()) {
            particle = spriteGetter.apply(owner.resolveTexture(isBroken && owner.isTexturePresent("broken") ? "broken" : "tool"));
            smallConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (TransformationMatrix)TransformationMatrix.func_227983_a_(), (int)0, (ItemLayerPixels)smallPixels));
            if (largeTransforms != null) {
                largeConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture(isBroken && owner.isTexturePresent("broken_large") ? "broken_large" : "tool_large")), (TransformationMatrix)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
            }
        } else {
            for (int i = parts.size() - 1; i >= 0; --i) {
                ToolPart part = parts.get(i);
                if (part.hasMaterials()) {
                    int index = part.getIndex();
                    MaterialId material = null;
                    if (index < materials.size()) {
                        material = materials.get(index);
                    }
                    particle = MaterialModel.getPartQuads(smallConsumer, owner, spriteGetter, TransformationMatrix.func_227983_a_(), part.getName(isBroken, false), -1, material, smallPixels);
                    if (largeTransforms == null) continue;
                    MaterialModel.getPartQuads(largeConsumer, owner, spriteGetter, largeTransforms, part.getName(isBroken, true), -1, material, largePixels);
                    continue;
                }
                particle = spriteGetter.apply(owner.resolveTexture(part.getName(isBroken, false)));
                smallConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (TransformationMatrix)TransformationMatrix.func_227983_a_(), (int)0, (ItemLayerPixels)smallPixels));
                if (largeTransforms == null) continue;
                largeConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture(part.getName(isBroken, true))), (TransformationMatrix)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
            }
        }
        ImmutableMap transformMap = Maps.immutableEnumMap((Map)PerspectiveMapWrapper.getTransforms((IModelTransform)owner.getCombinedTransform()));
        if (largeTransforms != null) {
            return new BakedLargeToolModel(largeBuilder.build(), smallBuilder.build(), particle, transformMap, overrides, owner.isSideLit());
        }
        return new BakedItemModel(smallBuilder.build(), particle, transformMap, overrides, true, owner.isSideLit());
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TransformationMatrix largeTransforms = this.isLarge ? new TransformationMatrix(new Vector3f((this.offset.field_189982_i - 8.0f) / 32.0f, (-this.offset.field_189983_j - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        overrides = new MaterialOverrideHandler(owner, this.toolParts, this.firstModifiers, largeTransforms, this.modifierModels);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, Collections.emptyList(), null, overrides);
    }

    public ToolModel(List<ToolPart> toolParts, boolean isLarge, Vector2f offset, List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, List<Modifier> firstModifiers) {
        this.toolParts = toolParts;
        this.isLarge = isLarge;
        this.offset = offset;
        this.smallModifierRoots = smallModifierRoots;
        this.largeModifierRoots = largeModifierRoots;
        this.firstModifiers = firstModifiers;
    }

    private static class ToolCacheKey {
        private final List<MaterialId> materials;
        private final List<Object> modifierData;
        private final boolean broken;

        public ToolCacheKey(List<MaterialId> materials, List<Object> modifierData, boolean broken) {
            this.materials = materials;
            this.modifierData = modifierData;
            this.broken = broken;
        }

        public List<MaterialId> getMaterials() {
            return this.materials;
        }

        public List<Object> getModifierData() {
            return this.modifierData;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToolCacheKey)) {
                return false;
            }
            ToolCacheKey other = (ToolCacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<MaterialId> this$materials = this.getMaterials();
            List<MaterialId> other$materials = other.getMaterials();
            if (this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials)) {
                return false;
            }
            List<Object> this$modifierData = this.getModifierData();
            List<Object> other$modifierData = other.getModifierData();
            if (this$modifierData == null ? other$modifierData != null : !((Object)this$modifierData).equals(other$modifierData)) {
                return false;
            }
            return this.isBroken() == other.isBroken();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ToolCacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MaterialId> $materials = this.getMaterials();
            result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
            List<Object> $modifierData = this.getModifierData();
            result = result * 59 + ($modifierData == null ? 43 : ((Object)$modifierData).hashCode());
            result = result * 59 + (this.isBroken() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ToolModel.ToolCacheKey(materials=" + this.getMaterials() + ", modifierData=" + this.getModifierData() + ", broken=" + this.isBroken() + ")";
        }
    }

    private static class Loader
    implements IModelLoader<ToolModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ToolModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            List parts = Collections.emptyList();
            if (modelContents.has("parts")) {
                parts = JsonHelper.parseList((JsonObject)modelContents, (String)"parts", ToolPart::read);
            }
            boolean isLarge = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"large", (boolean)false);
            Vector2f offset = Vector2f.field_189974_a;
            if (modelContents.has("large_offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "large_offset");
            }
            List smallModifierRoots = Collections.emptyList();
            List largeModifierRoots = Collections.emptyList();
            if (modelContents.has("modifier_roots")) {
                if (isLarge) {
                    JsonObject modifierRoots = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"modifier_roots");
                    BiFunction<JsonElement, String, ResourceLocation> parser = (element, string) -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)string));
                    smallModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"small", parser);
                    largeModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"large", parser);
                } else {
                    smallModifierRoots = JsonHelper.parseList((JsonObject)modelContents, (String)"modifier_roots", (element, string) -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)string)));
                }
            }
            List firstModifiers = Collections.emptyList();
            if (modelContents.has("first_modifiers")) {
                firstModifiers = JsonHelper.parseList((JsonObject)modelContents, (String)"first_modifiers", (element, key) -> JsonUtils.convertToEntry(TinkerRegistries.MODIFIERS, element, key));
            }
            return new ToolModel(parts, isLarge, offset, smallModifierRoots, largeModifierRoots, firstModifiers);
        }
    }

    private static class BakedLargeToolGui
    extends BakedModelWrapper<BakedLargeToolModel> {
        private final List<BakedQuad> guiQuads;

        public BakedLargeToolGui(BakedLargeToolModel model, List<BakedQuad> guiQuads) {
            super((IBakedModel)model);
            this.guiQuads = guiQuads;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.guiQuads;
            }
            return ImmutableList.of();
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transform, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)((BakedLargeToolModel)this.originalModel).transforms, (ItemCameraTransforms.TransformType)transform, (MatrixStack)mat);
        }
    }

    private static class BakedLargeToolModel
    implements IBakedModel {
        private final ImmutableList<BakedQuad> largeQuads;
        private final TextureAtlasSprite particleTexture;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms;
        private final ItemOverrideList overrides;
        private final boolean isSideLit;
        private final IBakedModel guiModel;

        private BakedLargeToolModel(ImmutableList<BakedQuad> largeQuads, ImmutableList<BakedQuad> smallQuads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, ItemOverrideList overrides, boolean isSideLit) {
            this.largeQuads = largeQuads;
            this.particleTexture = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            this.isSideLit = isSideLit;
            this.guiModel = new BakedLargeToolGui(this, (List<BakedQuad>)smallQuads);
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.largeQuads;
            }
            return ImmutableList.of();
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack mat) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                return this.guiModel.handlePerspective(type, mat);
            }
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type, (MatrixStack)mat);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }
    }

    public static final class MaterialOverrideHandler
    extends ItemOverrideList {
        private final Cache<ToolCacheKey, IBakedModel> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final IModelConfiguration owner;
        private final List<ToolPart> toolParts;
        private final List<Modifier> firstModifiers;
        @Nullable
        private final TransformationMatrix largeTransforms;
        private final Map<Modifier, IBakedModifierModel> modifierModels;

        private MaterialOverrideHandler(IModelConfiguration owner, List<ToolPart> toolParts, List<Modifier> firstModifiers, @Nullable TransformationMatrix largeTransforms, Map<Modifier, IBakedModifierModel> modifierModels) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.firstModifiers = firstModifiers;
            this.largeTransforms = largeTransforms;
            this.modifierModels = modifierModels;
        }

        @Nullable
        public IBakedModifierModel getModifierModel(Modifier modifier) {
            return this.modifierModels.get(modifier);
        }

        private IBakedModel bakeDynamic(List<MaterialId> materials, IModifierToolStack tool) {
            return ToolModel.bakeInternal(this.owner, ModelLoader.defaultTextureGetter(), this.largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, materials, tool, ItemOverrideList.field_188022_a);
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            List<MaterialId> materialIds = MaterialIdNBT.from(stack).getMaterials();
            ToolStack tool = ToolStack.from(stack);
            boolean broken = ToolDamageUtil.isBroken(stack);
            if (!broken && materialIds.isEmpty() && tool.getUpgrades().isEmpty()) {
                return originalModel;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
                Object cacheKey;
                IBakedModifierModel model = this.modifierModels.get(entry.getModifier());
                if (model == null || (cacheKey = model.getCacheKey(tool, entry)) == null) continue;
                builder.add(cacheKey);
            }
            try {
                return (IBakedModel)this.cache.get((Object)new ToolCacheKey(materialIds, (List<Object>)builder.build(), broken), () -> this.bakeDynamic(materialIds, tool));
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                return originalModel;
            }
        }
    }

    private static class ToolPart {
        private final String name;
        private final int index;
        @Nullable
        private final String broken;

        public boolean hasBroken() {
            return this.broken != null;
        }

        public boolean hasMaterials() {
            return this.index >= 0;
        }

        public String getName(boolean isBroken, boolean isLarge) {
            String name = this.name;
            if (isBroken && this.broken != null) {
                name = this.broken;
            }
            if (isLarge) {
                name = "large_" + name;
            }
            return name;
        }

        public static ToolPart read(JsonObject json) {
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            int index = JSONUtils.func_151208_a((JsonObject)json, (String)"index", (int)-1);
            String broken = null;
            if (json.has("broken")) {
                broken = JSONUtils.func_151200_h((JsonObject)json, (String)"broken");
            }
            return new ToolPart(name, index, broken);
        }

        public ToolPart(String name, int index, @Nullable String broken) {
            this.name = name;
            this.index = index;
            this.broken = broken;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class FirstModifier {
        private final ModifierEntry entry;
        private final IBakedModifierModel model;
        private final int modelIndex;

        public FirstModifier(ModifierEntry entry, IBakedModifierModel model, int modelIndex) {
            this.entry = entry;
            this.model = model;
            this.modelIndex = modelIndex;
        }
    }
}

