/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public abstract class AbstractMaterialRenderInfoProvider
extends GenericDataProvider {
    private final Map<MaterialId, RenderInfoBuilder> allRenderInfo = new HashMap<MaterialId, RenderInfoBuilder>();
    @Nullable
    private final AbstractMaterialSpriteProvider materialSprites;

    public AbstractMaterialRenderInfoProvider(DataGenerator gen, @Nullable AbstractMaterialSpriteProvider materialSprites) {
        super(gen, ResourcePackType.CLIENT_RESOURCES, "models/tool_materials", MaterialRenderInfoLoader.GSON);
        this.materialSprites = materialSprites;
    }

    public AbstractMaterialRenderInfoProvider(DataGenerator gen) {
        this(gen, (AbstractMaterialSpriteProvider)null);
    }

    protected abstract void addMaterialRenderInfo();

    public void func_200398_a(DirectoryCache cache) {
        this.addMaterialRenderInfo();
        this.allRenderInfo.forEach((materialId, info) -> this.saveThing(cache, (ResourceLocation)materialId, info.build()));
    }

    private RenderInfoBuilder getBuilder(MaterialId materialId) {
        AbstractMaterialSpriteProvider.MaterialSpriteInfo spriteInfo;
        RenderInfoBuilder builder = new RenderInfoBuilder();
        if (this.materialSprites != null && (spriteInfo = this.materialSprites.getMaterialInfo(materialId)) != null) {
            int color;
            String[] fallbacks = spriteInfo.getFallbacks();
            if (fallbacks.length > 0) {
                builder.fallbacks(fallbacks);
            }
            if ((color = spriteInfo.getTransformer().getFallbackColor()) != -1) {
                builder.color(color & 0xFF00 | color >> 16 & 0xFF | color << 16 & 0xFF0000);
            }
            builder.generator(spriteInfo);
        }
        return builder;
    }

    protected RenderInfoBuilder buildRenderInfo(MaterialId materialId) {
        return this.allRenderInfo.computeIfAbsent(materialId, this::getBuilder);
    }

    protected static class RenderInfoBuilder {
        private ResourceLocation texture = null;
        private String[] fallbacks;
        private int color = -1;
        private boolean skipUniqueTexture;
        private int luminosity = 0;
        private MaterialRenderInfoJson.MaterialGeneratorJson generator = null;

        protected RenderInfoBuilder() {
        }

        public RenderInfoBuilder fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
            return this;
        }

        public MaterialRenderInfoJson build() {
            return new MaterialRenderInfoJson(this.texture, this.fallbacks, String.format("%06X", this.color), this.skipUniqueTexture ? Boolean.TRUE : null, this.luminosity, this.generator);
        }

        public RenderInfoBuilder texture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public RenderInfoBuilder color(int color) {
            this.color = color;
            return this;
        }

        public RenderInfoBuilder skipUniqueTexture(boolean skipUniqueTexture) {
            this.skipUniqueTexture = skipUniqueTexture;
            return this;
        }

        public RenderInfoBuilder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public RenderInfoBuilder generator(MaterialRenderInfoJson.MaterialGeneratorJson generator) {
            this.generator = generator;
            return this;
        }
    }
}

