/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

@OnlyIn(value=Dist.CLIENT)
public class ContentMaterial
extends PageContent {
    private static final ITextComponent PART_BUILDER = TConstruct.makeTranslation("book", "material.part_builder");
    private static final String CAST_FROM = TConstruct.makeTranslationKey("book", "material.cast_from");
    private static final String COMPOSITE_FROM = TConstruct.makeTranslationKey("book", "material.composite_from");
    public static final String ID = "toolmaterial";
    private transient IMaterial material;
    private transient List<ItemStack> repairStacks;
    @SerializedName(value="material")
    public String materialName;
    public boolean detailed;

    public ContentMaterial(IMaterial material, boolean detailed) {
        this.materialName = material.getIdentifier().toString();
        this.material = material;
        this.detailed = detailed;
    }

    protected IMaterial getMaterial() {
        if (this.material == null) {
            this.material = MaterialRegistry.getMaterial(new MaterialId(this.materialName));
        }
        return this.material;
    }

    protected List<ItemStack> getRepairStacks() {
        if (this.repairStacks == null) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return Collections.emptyList();
            }
            this.repairStacks = RecipeHelper.getUIRecipes((RecipeManager)world.func_199532_z(), RecipeTypes.MATERIAL, MaterialRecipe.class, recipe -> recipe.getMaterial() == this.material).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().func_193365_a())).collect(Collectors.toList());
            if (this.repairStacks.isEmpty()) {
                TConstruct.LOG.debug("Material with id " + (Object)((Object)this.material.getIdentifier()) + " has no representation items associated with it, using repair kit");
                this.repairStacks = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(this.material.getIdentifier()));
            }
        }
        return this.repairStacks;
    }

    public List<ItemStack> getDisplayStacks() {
        return this.getRepairStacks();
    }

    public ITextComponent getTitle() {
        return this.getMaterial().getDisplayName();
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        IMaterial material = this.getMaterial();
        this.addTitle(list, this.getTitle().getString(), true, material.getColor().func_240742_a_());
        this.addDisplayItems(list, rightSide ? BookScreen.PAGE_WIDTH - 18 : 0, material.getIdentifier());
        int col_margin = 22;
        int top = this.getTitleHeight();
        int left = rightSide ? 0 : col_margin;
        int y = top + 5;
        int x = left + 5;
        int w = BookScreen.PAGE_WIDTH / 2 - 5;
        int headTraits = this.addStatsDisplay(x, y, w, list, material, HeadMaterialStats.ID);
        int handleTraits = this.addStatsDisplay(x + w, y, w - 10, list, material, HandleMaterialStats.ID);
        this.addStatsDisplay(x, (y += 65) + 10 * headTraits, w, list, material, ExtraMaterialStats.ID);
        MaterialId id = material.getIdentifier();
        String textKey = String.format(this.detailed ? "material.%s.%s.encyclopedia" : "material.%s.%s.flavor", id.func_110624_b(), id.func_110623_a());
        if (I18n.func_188566_a((String)textKey)) {
            String translated = ForgeI18n.getPattern((String)textKey);
            if (!this.detailed) {
                translated = '\"' + translated + '\"';
            }
            TextData flavourData = new TextData(translated);
            flavourData.italic = !this.detailed;
            list.add((BookElement)new TextElement(x + w - 16, y + 10 * handleTraits, w, 60, new TextData[]{flavourData}));
        }
    }

    protected int addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, IMaterial material, MaterialStatsId statsId) {
        Optional stats = MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), statsId);
        if (!stats.isPresent()) {
            return 0;
        }
        List<ModifierEntry> traits = MaterialRegistry.getInstance().getTraits(material.getIdentifier(), statsId);
        LinkedList parts = Lists.newLinkedList();
        for (IToolPart part : this.getToolParts()) {
            if (part.getStatType() != statsId) continue;
            parts.add(part.withMaterial(material));
        }
        int textOffset = 0;
        if (!parts.isEmpty()) {
            TinkerItemElement display = new TinkerItemElement(x, y + 1, 0.5f, parts);
            list.add((BookElement)display);
            textOffset = 10;
        }
        TextElement name = new TextElement(x + textOffset, y, w - textOffset, 10, ((IMaterialStats)stats.get()).getLocalizedName().getString());
        name.text[0].bold = true;
        name.text[0].underlined = true;
        list.add((BookElement)name);
        y += 12;
        ArrayList lineData = Lists.newArrayList();
        lineData.addAll(ContentMaterial.getStatLines((IMaterialStats)stats.get()));
        lineData.addAll(ContentMaterial.getTraitLines(traits, material));
        list.add((BookElement)new TextComponentElement(x, y, w, BookScreen.PAGE_HEIGHT, (Collection)lineData));
        return traits.size();
    }

    private static List<TextComponentData> getStatLines(IMaterialStats stats) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
            TextComponentData text = new TextComponentData(stats.getLocalizedInfo().get(i));
            text.tooltips = stats.getLocalizedDescriptions().get(i).getString().isEmpty() ? null : new ITextComponent[]{stats.getLocalizedDescriptions().get(i)};
            lineData.add(text);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private static List<TextComponentData> getTraitLines(List<ModifierEntry> traits, IMaterial material) {
        ArrayList<TextComponentData> lineData = new ArrayList<TextComponentData>();
        for (ModifierEntry trait : traits) {
            Modifier mod = trait.getModifier();
            TextComponentData textComponentData = new TextComponentData(mod.getDisplayName());
            List<ITextComponent> textComponents = mod.getDescriptionList(trait.getLevel());
            ArrayList<Object> formatted = new ArrayList<Object>();
            for (int index = 0; index < textComponents.size(); ++index) {
                ITextComponent textComponent = textComponents.get(index);
                if (index == 0) {
                    formatted.add(textComponent.func_230532_e_().func_240700_a_(style -> style.func_240718_a_(material.getColor())));
                    continue;
                }
                formatted.add(textComponent);
            }
            textComponentData.tooltips = formatted.toArray(new ITextComponent[0]);
            textComponentData.text = textComponentData.text.func_230532_e_().func_240699_a_(TextFormatting.DARK_GRAY).func_240699_a_(TextFormatting.UNDERLINE);
            lineData.add(textComponentData);
            lineData.add(new TextComponentData("\n"));
        }
        return lineData;
    }

    private static boolean hasStatType(MaterialId materialId, MaterialStatsId statsId) {
        return MaterialRegistry.getInstance().getMaterialStats(materialId, statsId).isPresent();
    }

    private static IMaterial getFirstMaterialWithType(MaterialStatsId statsId) {
        for (IMaterial material : MaterialRegistry.getMaterials()) {
            if (!ContentMaterial.hasStatType(material.getIdentifier(), statsId)) continue;
            return material;
        }
        return IMaterial.UNKNOWN;
    }

    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)HeadMaterialStats.ID) || statsId.equals((Object)HandleMaterialStats.ID) || statsId.equals((Object)ExtraMaterialStats.ID);
    }

    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialId materialId) {
        List<MaterialFluidRecipe> fluids;
        TinkerItemElement elementItem;
        IMaterial material = this.getMaterial();
        if (material.isCraftable()) {
            ItemStack partBuilder = new ItemStack((IItemProvider)TinkerTables.partBuilder.func_199767_j());
            elementItem = new TinkerItemElement(partBuilder);
            elementItem.tooltip = ImmutableList.of((Object)PART_BUILDER);
            displayTools.add(elementItem);
        }
        if (!(fluids = MaterialCastingLookup.getCastingFluids(materialId)).isEmpty()) {
            elementItem = new TinkerItemElement(0, 0, 1.0f, fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).map(fluid -> new ItemStack((IItemProvider)fluid.getFluid().func_204524_b())).collect(Collectors.toList()));
            FluidStack firstFluid = fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).findFirst().orElse(FluidStack.EMPTY);
            elementItem.tooltip = ImmutableList.of((Object)new TranslationTextComponent(CAST_FROM, new Object[]{firstFluid.getFluid().getAttributes().getDisplayName(firstFluid)}));
            displayTools.add(elementItem);
        }
        List<MaterialFluidRecipe> composites = MaterialCastingLookup.getCompositeFluids(materialId);
        for (MaterialFluidRecipe composite : composites) {
            IMaterial input = composite.getInput();
            if (input == null) continue;
            TinkerItemElement elementItem2 = new TinkerItemElement(0, 0, 1.0f, MaterialCastingLookup.getAllItemCosts().stream().map(Map.Entry::getKey).filter(part -> part.canUseMaterial(input) && part.canUseMaterial(material)).map(part -> part.withMaterial(input)).collect(Collectors.toList()));
            FluidStack firstFluid = composite.getFluids().stream().findFirst().orElse(FluidStack.EMPTY);
            elementItem2.tooltip = ImmutableList.of((Object)new TranslationTextComponent(COMPOSITE_FROM, new Object[]{firstFluid.getFluid().getAttributes().getDisplayName(firstFluid), input.getDisplayName()}));
            displayTools.add(elementItem2);
        }
    }

    protected void addDisplayItems(ArrayList<BookElement> list, int x, MaterialId materialId) {
        ArrayList displayTools = Lists.newArrayList();
        displayTools.add(new TinkerItemElement(0, 0, 1.0f, this.getRepairStacks()));
        this.addPrimaryDisplayItems(displayTools, materialId);
        if (displayTools.size() < 9) {
            block0: for (Item item : TinkerTags.Items.MULTIPART_TOOL.func_230236_b_()) {
                if (!(item instanceof IModifiable)) continue;
                IModifiable tool = (IModifiable)item;
                List<PartRequirement> requirements = tool.getToolDefinition().getData().getParts();
                ArrayList<IMaterial> materials = new ArrayList<IMaterial>(requirements.size());
                IMaterial material = MaterialRegistry.getMaterial(materialId);
                boolean usedMaterial = false;
                for (PartRequirement part : requirements) {
                    if (!this.supportsStatType(part.getStatType())) continue block0;
                    if (ContentMaterial.hasStatType(materialId, part.getStatType())) {
                        materials.add(material);
                        usedMaterial = true;
                        continue;
                    }
                    materials.add(ContentMaterial.getFirstMaterialWithType(part.getStatType()));
                }
                if (!usedMaterial) continue;
                ItemStack display = ToolBuildHandler.buildItemFromMaterials(tool, materials);
                displayTools.add(new TinkerItemElement(display));
                if (displayTools.size() != 9) continue;
                break;
            }
        }
        if (!displayTools.isEmpty()) {
            int y = this.getTitleHeight() - 5;
            for (ItemElement element : displayTools) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }

    private List<IToolPart> getToolParts() {
        return TinkerTags.Items.TOOL_PARTS.func_230236_b_().stream().filter(item -> item instanceof IToolPart).map(item -> (IToolPart)item).collect(Collectors.toList());
    }
}

