/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.loot.RetexturedLootFunction;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockLootTableProvider
extends BlockLootTables {
    private final Map<ResourceLocation, LootTable.Builder> loot_tables = Maps.newHashMap();
    private static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private static final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.SHEARS));
    private static final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = SHEARS.func_216297_a(SILK_TOUCH);

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "tconstruct".equals(Objects.requireNonNull(block.getRegistryName()).func_110624_b())).collect(Collectors.toList());
    }

    protected void addTables() {
        this.addCommon();
        this.addDecorative();
        this.addGadgets();
        this.addWorld();
        this.addTools();
        this.addSmeltery();
        this.addFoundry();
    }

    private void addCommon() {
        this.registerBuildingLootTables(TinkerCommons.blazewood);
        this.registerBuildingLootTables(TinkerCommons.lavawood);
        this.registerFenceBuildingLootTables(TinkerMaterials.nahuatl);
        this.func_218492_c((Block)TinkerModifiers.silkyJewelBlock.get());
        this.func_218492_c((Block)TinkerMaterials.copper.get());
        this.func_218492_c((Block)TinkerMaterials.cobalt.get());
        this.func_218492_c((Block)TinkerMaterials.slimesteel.get());
        this.func_218492_c((Block)TinkerMaterials.tinkersBronze.get());
        this.func_218492_c((Block)TinkerMaterials.roseGold.get());
        this.func_218492_c((Block)TinkerMaterials.pigIron.get());
        this.func_218492_c((Block)TinkerMaterials.manyullyn.get());
        this.func_218492_c((Block)TinkerMaterials.hepatizon.get());
        this.func_218492_c((Block)TinkerMaterials.queensSlime.get());
        this.func_218492_c((Block)TinkerMaterials.soulsteel.get());
        this.func_218492_c((Block)TinkerMaterials.knightslime.get());
    }

    private void addDecorative() {
        this.func_218492_c((Block)TinkerCommons.obsidianPane.get());
        this.func_218492_c((Block)TinkerCommons.clearGlass.get());
        this.func_218492_c((Block)TinkerCommons.clearGlassPane.get());
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            this.func_218492_c((Block)TinkerCommons.clearStainedGlass.get((Enum)color));
            this.func_218492_c((Block)TinkerCommons.clearStainedGlassPane.get((Enum)color));
        }
        this.func_218492_c((Block)TinkerCommons.soulGlass.get());
        this.func_218492_c((Block)TinkerCommons.soulGlassPane.get());
        this.registerBuildingLootTables(TinkerCommons.mudBricks);
    }

    private void addTools() {
        this.func_218522_a((Block)TinkerTables.tinkersChest.get(), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("color", "display.color"))));
        this.func_218522_a((Block)TinkerTables.partChest.get(), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY))));
        this.func_218522_a((Block)TinkerTables.castChest.get(), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Items", "TinkerData.Items"))));
        Function<Block, LootTable.Builder> addTable = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_(RetexturedLootFunction::new));
        this.func_218522_a((Block)TinkerTables.craftingStation.get(), addTable);
        this.func_218522_a((Block)TinkerTables.partBuilder.get(), addTable);
        this.func_218522_a((Block)TinkerTables.tinkerStation.get(), addTable);
        this.func_218522_a((Block)TinkerTables.tinkersAnvil.get(), addTable);
        this.func_218522_a((Block)TinkerTables.scorchedAnvil.get(), addTable);
    }

    private void addWorld() {
        this.func_218492_c((Block)TinkerWorld.cobaltOre.get());
        this.func_218492_c((Block)TinkerWorld.copperOre.get());
        TinkerWorld.heads.forEach(arg_0 -> ((BlockLootTableProvider)this).func_218492_c(arg_0));
        TinkerWorld.slime.forEach((type, block) -> {
            if (type != SlimeType.EARTH) {
                this.func_218492_c((Block)block);
            }
        });
        TinkerWorld.congealedSlime.forEach((slime, block) -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218530_a((Block)block, (IItemProvider)((IItemProvider)TinkerCommons.slimeball.get((Enum)slime)), (IRandomRange)ConstantRange.func_215835_a((int)4))));
        TinkerWorld.slimeDirt.forEach(arg_0 -> ((BlockLootTableProvider)this).func_218492_c(arg_0));
        TinkerWorld.vanillaSlimeGrass.forEach(block -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)Blocks.field_150346_d)));
        TinkerWorld.earthSlimeGrass.forEach(block -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.EARTH)))));
        TinkerWorld.skySlimeGrass.forEach(block -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.SKY)))));
        TinkerWorld.enderSlimeGrass.forEach(block -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.ENDER)))));
        TinkerWorld.ichorSlimeGrass.forEach(block -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.ICHOR)))));
        TinkerWorld.slimeSapling.forEach(arg_0 -> ((BlockLootTableProvider)this).func_218492_c(arg_0));
        TinkerWorld.slimeTallGrass.forEach(block -> this.func_218522_a((Block)block, BlockLootTableProvider::onlyShearsTag));
        for (SlimeType type2 : SlimeType.OVERWORLD) {
            this.func_218522_a((Block)TinkerWorld.slimeLeaves.get((Enum)type2), block -> BlockLootTableProvider.randomDropSlimeBallOrSapling(type2, block, (Block)TinkerWorld.slimeSapling.get((Enum)type2), field_218579_g));
            this.func_218522_a((Block)TinkerWorld.slimeFern.get((Enum)type2), BlockLootTableProvider::onlyShearsTag);
        }
        for (SlimeType type2 : SlimeType.NETHER) {
            this.func_218492_c((Block)TinkerWorld.slimeLeaves.get((Enum)type2));
            this.func_218492_c((Block)TinkerWorld.slimeFern.get((Enum)type2));
        }
        this.func_218522_a((Block)TinkerWorld.skySlimeVine.get(), BlockLootTableProvider::onlyShearsTag);
        this.func_218522_a((Block)TinkerWorld.enderSlimeVine.get(), BlockLootTableProvider::onlyShearsTag);
        this.registerWoodLootTables(TinkerWorld.greenheart);
        this.registerWoodLootTables(TinkerWorld.skyroot);
        this.registerWoodLootTables(TinkerWorld.bloodshroom);
    }

    private void addGadgets() {
        this.func_218492_c((Block)TinkerGadgets.punji.get());
        TinkerGadgets.cake.forEach(block -> this.func_218507_a((Block)block, BlockLootTableProvider.func_218482_a()));
        this.func_218507_a((Block)TinkerGadgets.magmaCake.get(), BlockLootTableProvider.func_218482_a());
    }

    private void addSmeltery() {
        this.func_218492_c((Block)TinkerSmeltery.grout.get());
        this.func_218492_c((Block)TinkerSmeltery.searedMelter.get());
        this.func_218492_c((Block)TinkerSmeltery.searedHeater.get());
        this.func_218492_c((Block)TinkerSmeltery.smelteryController.get());
        this.registerBuildingLootTables(TinkerSmeltery.searedStone);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedCobble);
        this.registerBuildingLootTables(TinkerSmeltery.searedPaver);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedBricks);
        this.func_218492_c((Block)TinkerSmeltery.searedCrackedBricks.get());
        this.func_218492_c((Block)TinkerSmeltery.searedFancyBricks.get());
        this.func_218492_c((Block)TinkerSmeltery.searedTriangleBricks.get());
        this.func_218492_c((Block)TinkerSmeltery.searedLadder.get());
        this.func_218492_c((Block)TinkerSmeltery.searedGlass.get());
        this.func_218492_c((Block)TinkerSmeltery.searedGlassPane.get());
        this.func_218492_c((Block)TinkerSmeltery.searedDrain.get());
        this.func_218492_c((Block)TinkerSmeltery.searedChute.get());
        this.func_218492_c((Block)TinkerSmeltery.searedDuct.get());
        Function<Block, LootTable.Builder> dropTank = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("tank", "tank")));
        TinkerSmeltery.searedTank.forEach(block -> this.func_218522_a((Block)block, dropTank));
        this.func_218522_a((Block)TinkerSmeltery.searedLantern.get(), dropTank);
        this.func_218492_c((Block)TinkerSmeltery.searedFaucet.get());
        this.func_218492_c((Block)TinkerSmeltery.searedChannel.get());
        this.func_218492_c((Block)TinkerSmeltery.searedBasin.get());
        this.func_218492_c((Block)TinkerSmeltery.searedTable.get());
    }

    private void addFoundry() {
        this.func_218492_c((Block)TinkerSmeltery.netherGrout.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedAlloyer.get());
        this.func_218492_c((Block)TinkerSmeltery.foundryController.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedStone.get());
        this.func_218492_c((Block)TinkerSmeltery.polishedScorchedStone.get());
        this.registerFenceBuildingLootTables(TinkerSmeltery.scorchedBricks);
        this.func_218492_c((Block)TinkerSmeltery.chiseledScorchedBricks.get());
        this.registerBuildingLootTables(TinkerSmeltery.scorchedRoad);
        this.func_218492_c((Block)TinkerSmeltery.scorchedLadder.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedGlass.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedGlassPane.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedDrain.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedChute.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedDuct.get());
        Function<Block, LootTable.Builder> dropTank = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("tank", "tank")));
        TinkerSmeltery.scorchedTank.forEach(block -> this.func_218522_a((Block)block, dropTank));
        this.func_218522_a((Block)TinkerSmeltery.scorchedLantern.get(), dropTank);
        this.func_218492_c((Block)TinkerSmeltery.scorchedFaucet.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedChannel.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedBasin.get());
        this.func_218492_c((Block)TinkerSmeltery.scorchedTable.get());
    }

    protected static LootTable.Builder onlyShearsTag(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SHEARS).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    private static LootTable.Builder droppingSilkOrShearsTag(Block block, LootEntry.Builder<?> alternativeLootEntry) {
        return BlockLootTableProvider.func_218494_a((Block)block, (ILootCondition.IBuilder)SILK_TOUCH_OR_SHEARS, alternativeLootEntry);
    }

    private static LootTable.Builder dropSapling(Block blockIn, Block saplingIn, float ... fortuneIn) {
        return BlockLootTableProvider.droppingSilkOrShearsTag(blockIn, ((StandaloneLootEntry.Builder)BlockLootTableProvider.func_218560_a((IItemProvider)blockIn, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)saplingIn))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])fortuneIn)));
    }

    private static LootTable.Builder randomDropSlimeBallOrSapling(SlimeType foliageType, Block blockIn, Block sapling, float ... fortuneIn) {
        return BlockLootTableProvider.dropSapling(blockIn, sapling, fortuneIn).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(field_218577_e).func_216045_a(((StandaloneLootEntry.Builder)BlockLootTableProvider.func_218560_a((IItemProvider)blockIn, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerCommons.slimeball.get((Enum)foliageType))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.05f}))));
    }

    private static LootTable.Builder droppingWithFunctions(Block block, Function<StandaloneLootEntry.Builder<?>, StandaloneLootEntry.Builder<?>> mapping) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTableProvider.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)mapping.apply(ItemLootEntry.func_216168_a((IItemProvider)block)))));
    }

    private void registerBuildingLootTables(BuildingBlockObject object) {
        this.func_218492_c((Block)object.get());
        this.func_218522_a((Block)object.getSlab(), BlockLootTables::func_218513_d);
        this.func_218492_c((Block)object.getStairs());
    }

    private void registerWallBuildingLootTables(WallBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.func_218492_c((Block)object.getWall());
    }

    private void registerFenceBuildingLootTables(FenceBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.func_218492_c((Block)object.getFence());
    }

    private void registerWoodLootTables(WoodBlockObject object) {
        this.registerFenceBuildingLootTables((FenceBuildingBlockObject)object);
        this.func_218492_c(object.getLog());
        this.func_218492_c(object.getStrippedLog());
        this.func_218492_c(object.getWood());
        this.func_218492_c(object.getStrippedWood());
        this.func_218492_c((Block)object.getFenceGate());
        this.func_218522_a((Block)object.getDoor(), BlockLootTables::func_239829_a_);
        this.func_218492_c((Block)object.getTrapdoor());
        this.func_218492_c((Block)object.getPressurePlate());
        this.func_218492_c((Block)object.getButton());
        this.func_218492_c((Block)object.getSign());
    }
}

