/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.featuredservers;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.alwa.featuredservers.FeaturedList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="featuredservers")
public class FeaturedServers {
    public static final Logger LOGGER = LogManager.getLogger();
    private static String FMLConfigFolder;

    public FeaturedServers() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            try {
                this.doClientStuff((FMLClientSetupEvent)event);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) throws IOException {
        File featuredServerList;
        File configFolder = new File(FMLConfigFolder, "FeaturedServers");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(featuredServerList = new File(configFolder, "featuredservers.json")).exists()) {
            featuredServerList.createNewFile();
            FileWriter writer = new FileWriter(featuredServerList);
            writer.write("[\n  {\n    \"serverName\": \"Featured Server\",\n    \"serverIP\": \"127.0.0.1\",\n    \"forceResourcePack\": \"true\",\n    \"disableButtons\": \"true\"\n  },\n  {\n    \"serverName\": \"Another Server!\",\n    \"serverIP\": \"192.168.1.1\",\n    \"forceResourcePack\": \"false\",\n    \"disableButtons\": \"false\"\n  }\n]");
            writer.close();
        }
        FileReader serversFile = new FileReader(featuredServerList.getPath());
        Gson gson = new Gson();
        JsonReader reader = new JsonReader((Reader)serversFile);
        ServerDataHelper[] featuredList = (ServerDataHelper[])gson.fromJson(reader, ServerDataHelper[].class);
        new FeaturedList().doFeaturedListStuff(featuredList);
    }

    void onConfigLoad(ModConfig.Loading event) {
        FMLConfigFolder = event.getConfig().getFullPath().getParent().toString();
    }

    public static class ServerDataHelper {
        public String serverName;
        public String serverIP;
        public Boolean forceResourcePack;
        public Boolean disableButtons;
    }
}

