/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SingleTransferMessage {
    private final int slotNumber;

    public SingleTransferMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static SingleTransferMessage decode(PacketBuffer buf) {
        byte slotNumber = buf.readByte();
        return new SingleTransferMessage(slotNumber);
    }

    public static void encode(SingleTransferMessage message, PacketBuffer buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(SingleTransferMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container != null && message.slotNumber >= 0 && message.slotNumber < container.field_75151_b.size()) {
                Slot slot = (Slot)container.field_75151_b.get(message.slotNumber);
                if (!slot.func_82869_a((PlayerEntity)player)) {
                    return;
                }
                ItemStack sourceStack = slot.func_75211_c();
                if (sourceStack.func_190916_E() == 1) {
                    container.func_184996_a(message.slotNumber, 0, ClickType.QUICK_MOVE, (PlayerEntity)player);
                } else if (!sourceStack.func_190926_b()) {
                    ItemStack copyStack = sourceStack.func_77946_l();
                    sourceStack.func_190920_e(1);
                    copyStack.func_190918_g(1);
                    container.func_184996_a(message.slotNumber, 0, ClickType.QUICK_MOVE, (PlayerEntity)player);
                    if (!slot.func_75216_d()) {
                        slot.func_75215_d(copyStack);
                    } else if (!player.func_191521_c(copyStack)) {
                        player.func_71019_a(copyStack, false);
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

