/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class BulkTransferAllMessage {
    private final int slotNumber;

    public BulkTransferAllMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static BulkTransferAllMessage decode(PacketBuffer buf) {
        byte slotNumber = buf.readByte();
        return new BulkTransferAllMessage(slotNumber);
    }

    public static void encode(BulkTransferAllMessage message, PacketBuffer buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(BulkTransferAllMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            block8: {
                ServerPlayerEntity player = context.getSender();
                if (player == null) {
                    return;
                }
                Container container = player.field_71070_bA;
                if (container == null || message.slotNumber < 0 || message.slotNumber >= container.field_75151_b.size()) break block8;
                Slot clickedSlot = (Slot)container.field_75151_b.get(message.slotNumber);
                boolean isProbablyMovingToPlayerInventory = false;
                if (!(clickedSlot.field_75224_c instanceof PlayerInventory)) {
                    isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(container);
                }
                if (isProbablyMovingToPlayerInventory) {
                    ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
                    ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
                    for (Slot slot : container.field_75151_b) {
                        if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.field_75224_c instanceof PlayerInventory)) continue;
                        if (slot.func_75216_d()) {
                            nonEmptySlots.add(slot);
                            continue;
                        }
                        if (PlayerInventory.func_184435_e((int)slot.getSlotIndex())) continue;
                        emptySlots.add(slot);
                    }
                    for (Slot slot : container.field_75151_b) {
                        if (!slot.func_82869_a((PlayerEntity)Objects.requireNonNull(player)) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                        BulkTransferAllMessage.bulkTransferPreferInventory((PlayerEntity)player, container, emptySlots, nonEmptySlots, slot);
                    }
                } else {
                    for (Slot slot : container.field_75151_b) {
                        if (!slot.func_82869_a((PlayerEntity)Objects.requireNonNull(player)) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                        container.func_184996_a(slot.field_75222_d, 0, ClickType.QUICK_MOVE, (PlayerEntity)player);
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static boolean bulkTransferPreferInventory(PlayerEntity player, Container container, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        PlayerInventory playerInventory = player.field_71071_by;
        ItemStack targetStack = slot.func_75211_c();
        if (targetStack.func_190926_b()) {
            return false;
        }
        container.func_184996_a(slot.field_75222_d, 0, ClickType.PICKUP, player);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = slot.func_75211_c();
            if (!ItemStack.func_185132_d((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.func_190916_E() < Math.min(slot.func_75219_a(), slot.func_178170_b(stack));
            if (!hasSpaceLeft) continue;
            container.func_184996_a(nonEmptySlot.field_75222_d, 0, ClickType.PICKUP, player);
            ItemStack mouseItem = playerInventory.func_70445_o();
            if (!mouseItem.func_190926_b()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            container.func_184996_a(emptySlot.field_75222_d, 0, ClickType.PICKUP, player);
            if (emptySlot.func_75216_d()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = playerInventory.func_70445_o()).func_190926_b()) continue;
            return true;
        }
        ItemStack mouseItem = playerInventory.func_70445_o();
        if (!mouseItem.func_190926_b()) {
            container.func_184996_a(slot.field_75222_d, 0, ClickType.PICKUP, player);
        }
        return false;
    }
}

