/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Lists;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public class DogRespawnData
implements IDogData {
    private final DogRespawnStorage storage;
    private final UUID uuid;
    private CompoundNBT data;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting"});

    protected DogRespawnData(DogRespawnStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    public String getDogName() {
        ITextComponent name = NBTUtil.getTextComponent(this.data, "CustomName");
        return name == null ? "" : name.getString();
    }

    @Override
    public UUID getOwnerId() {
        String str = this.data.func_74779_i("OwnerUUID");
        return "".equals(str) ? null : UUID.fromString(str);
    }

    @Override
    public String getOwnerName() {
        ITextComponent name = NBTUtil.getTextComponent(this.data, "lastKnownOwnerName");
        return name == null ? "" : name.getString();
    }

    public void populate(DogEntity dogIn) {
        this.data = new CompoundNBT();
        dogIn.func_189511_e(this.data);
        for (String tag : TAGS_TO_REMOVE) {
            this.data.func_82580_o(tag);
        }
        this.data.func_82580_o("UUID");
        this.data.func_82580_o("LoveCause");
    }

    @Nullable
    public DogEntity respawn(ServerWorld worldIn, PlayerEntity playerIn, BlockPos pos) {
        DogEntity dog = (DogEntity)((EntityType)DoggyEntityTypes.DOG.get()).func_220342_a(worldIn, (CompoundNBT)null, (ITextComponent)null, playerIn, pos, SpawnReason.TRIGGERED, true, false);
        if (dog == null) {
            return null;
        }
        CompoundNBT compoundnbt = dog.func_189511_e(new CompoundNBT());
        UUID uuid = dog.func_110124_au();
        compoundnbt.func_197643_a(this.data);
        dog.func_184221_a(uuid);
        dog.func_70020_e(compoundnbt);
        dog.setMode(EnumMode.DOCILE);
        dog.func_233687_w_(true);
        return dog;
    }

    public void read(CompoundNBT compound) {
        this.data = compound.func_74775_l("data");
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_218657_a("data", (INBT)this.data);
        return compound;
    }
}

