/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.EnumMode;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.entity.DoggyBeamEntity;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WhistleItem
extends Item {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new CompoundNBT());
                    stack.func_77978_p().func_74774_a("mode", (byte)0);
                }
                int mode = stack.func_77978_p().func_74762_e("mode");
                stack.func_77978_p().func_74768_a("mode", (mode + 1) % 7);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        byte mode = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("mode", 99)) {
            mode = stack.func_77978_p().func_74771_c("mode");
        }
        List dogsList = world.func_175647_a(DogEntity.class, player.func_174813_aQ().func_72314_b(100.0, 50.0, 100.0), dog -> dog.func_152114_e((LivingEntity)player));
        boolean successful = false;
        if (mode == 0) {
            if (!world.field_72995_K) {
                for (DogEntity dog2 : dogsList) {
                    dog2.func_233687_w_(false);
                    dog2.func_70661_as().func_75499_g();
                    dog2.func_70624_b(null);
                    if (dog2.getMode() == EnumMode.WANDERING) {
                        dog2.setMode(EnumMode.DOCILE);
                    }
                    successful = true;
                }
                if (ConfigValues.WHISTLE_SOUNDS) {
                    world.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)DoggySounds.WHISTLE_LONG.get(), SoundCategory.PLAYERS, 0.6f + world.field_73012_v.nextFloat() * 0.1f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
                }
                if (successful) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("dogcommand.come"), Util.field_240973_b_);
                }
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (mode == 1) {
            if (!world.field_72995_K) {
                for (DogEntity dog3 : dogsList) {
                    if (dog3.func_233684_eK_() || dog3.getMode() == EnumMode.WANDERING) continue;
                    if (dog3.func_70068_e((Entity)dog3.func_70902_q()) > 9.0) {
                        EntityUtil.tryToTeleportNearEntity((LivingEntity)dog3, dog3.func_70661_as(), dog3.func_70902_q(), 2);
                    }
                    successful = true;
                }
                if (ConfigValues.WHISTLE_SOUNDS) {
                    world.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)DoggySounds.WHISTLE_LONG.get(), SoundCategory.PLAYERS, 0.6f + world.field_73012_v.nextFloat() * 0.1f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
                }
                if (successful) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("dogcommand.heel"), Util.field_240973_b_);
                }
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (mode == 2) {
            if (!world.field_72995_K) {
                for (DogEntity dog4 : dogsList) {
                    dog4.func_233687_w_(true);
                    dog4.func_70661_as().func_75499_g();
                    dog4.func_70624_b(null);
                    if (dog4.getMode() == EnumMode.WANDERING) {
                        dog4.setMode(EnumMode.DOCILE);
                    }
                    successful = true;
                }
                if (ConfigValues.WHISTLE_SOUNDS) {
                    world.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)DoggySounds.WHISTLE_SHORT.get(), SoundCategory.PLAYERS, 0.6f + world.field_73012_v.nextFloat() * 0.1f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
                }
                if (successful) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("dogcommand.stay"), Util.field_240973_b_);
                }
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (mode == 3) {
            if (!world.field_72995_K) {
                for (DogEntity dog5 : dogsList) {
                    if (dog5.func_110138_aP() / 2.0f >= dog5.func_110143_aJ()) {
                        dog5.func_233687_w_(true);
                        dog5.func_70661_as().func_75499_g();
                        dog5.func_70624_b(null);
                    } else {
                        dog5.func_233687_w_(false);
                        dog5.func_70661_as().func_75499_g();
                        dog5.func_70624_b(null);
                    }
                    successful = true;
                }
                if (ConfigValues.WHISTLE_SOUNDS) {
                    world.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)DoggySounds.WHISTLE_LONG.get(), SoundCategory.PLAYERS, 0.6f + world.field_73012_v.nextFloat() * 0.1f, 0.4f + world.field_73012_v.nextFloat() * 0.2f);
                }
                if (successful) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("dogcommand.ok"), Util.field_240973_b_);
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        } else {
            if (mode == 4) {
                if (!world.field_72995_K && ConfigValues.WHISTLE_SOUNDS) {
                    world.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)DoggySounds.WHISTLE_SHORT.get(), SoundCategory.PLAYERS, 0.6f + world.field_73012_v.nextFloat() * 0.1f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
            if (mode == 5) {
                if (!world.field_72995_K) {
                    if (ConfigValues.WHISTLE_SOUNDS) {
                        world.func_184133_a((PlayerEntity)null, player.func_233580_cy_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    }
                    DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (LivingEntity)player);
                    doggyBeam.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 1.0f);
                    world.func_217376_c((Entity)doggyBeam);
                }
                return new ActionResult(ActionResultType.CONSUME, (Object)player.func_184586_b(hand));
            }
            if (mode == 6) {
                if (!world.field_72995_K) {
                    List roarDogs = dogsList.stream().filter(dog -> dog.getLevel((Supplier)DoggyTalents.ROARING_GALE) > 0).collect(Collectors.toList());
                    if (roarDogs.isEmpty()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("talent.doggytalents.roaring_gale.level"), true);
                    } else {
                        List cdDogs = roarDogs.stream().filter(dog -> dog.getDataOrDefault(RoaringGaleTalent.COOLDOWN, dog.field_70173_aa) <= dog.field_70173_aa).collect(Collectors.toList());
                        if (cdDogs.isEmpty()) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("talent.doggytalents.roaring_gale.cooldown"), true);
                        } else {
                            boolean anyHits = false;
                            for (DogEntity dog6 : dogsList) {
                                int level = dog6.getLevel((Supplier)DoggyTalents.ROARING_GALE);
                                int roarCooldown = dog6.field_70173_aa;
                                byte damage = (byte)(level > 4 ? level * 2 : level);
                                byte effectDuration = (byte)(level > 4 ? level * 14 : level * (level == 1 ? 20 : 12));
                                byte knockback = (byte)level;
                                boolean hit = false;
                                List list = dog6.field_70170_p.func_217357_a(LivingEntity.class, dog6.func_174813_aQ().func_72314_b((double)(level * 4), 4.0, (double)(level * 4)));
                                for (LivingEntity mob : list) {
                                    if (!(mob instanceof IMob)) continue;
                                    hit = true;
                                    mob.func_70097_a(DamageSource.field_76377_j, (float)damage);
                                    mob.func_195064_c(new EffectInstance(Effects.field_76421_d, (int)effectDuration, 127, false, false));
                                    mob.func_195064_c(new EffectInstance(Effects.field_188423_x, (int)effectDuration, 1, false, false));
                                    mob.func_70024_g((double)(MathHelper.func_76126_a((float)(mob.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(-MathHelper.func_76134_b((float)(mob.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                                }
                                if (hit) {
                                    dog6.func_184185_a(SoundEvents.field_187861_gG, 0.7f, 1.0f);
                                    roarCooldown += level >= 5 ? 60 : 100;
                                    anyHits = true;
                                } else {
                                    dog6.func_184185_a(SoundEvents.field_187857_gE, 1.0f, 1.2f);
                                    roarCooldown += level >= 5 ? 30 : 50;
                                }
                                dog6.setData(RoaringGaleTalent.COOLDOWN, roarCooldown);
                            }
                            if (!anyHits) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("talent.doggytalents.roaring_gale.miss"), true);
                            }
                        }
                    }
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)player.func_184586_b(hand));
    }

    public String func_77667_c(ItemStack stack) {
        int mode = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("mode", 99)) {
            mode = stack.func_77978_p().func_74771_c("mode");
        }
        return this.func_77658_a() + "." + mode;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.UNCOMMON;
    }
}

