/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BreedGoal
extends Goal {
    private static final EntityPredicate breedPredicate = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c().func_221009_d();
    private final AnimalEntity animal;
    private final Class<? extends AnimalEntity> mateClass;
    private final World world;
    private final double moveSpeed;
    protected AnimalEntity targetMate;
    private int spawnBabyDelay;

    public BreedGoal(AnimalEntity animal, double speedIn) {
        this(animal, speedIn, animal.getClass());
    }

    public BreedGoal(AnimalEntity animal, double moveSpeed, Class<? extends AnimalEntity> mateClass) {
        this.animal = animal;
        this.world = animal.field_70170_p;
        this.mateClass = mateClass;
        this.moveSpeed = moveSpeed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.animal.func_70880_s()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.animal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.animal.func_70646_bf());
        this.animal.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.animal.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.animal.func_234177_a_((ServerWorld)this.world, this.targetMate);
        }
    }

    @Nullable
    private AnimalEntity getNearbyMate() {
        List entities = this.world.func_175647_a(this.mateClass, this.animal.func_174813_aQ().func_186662_g(8.0), this::filterEntities);
        return (AnimalEntity)EntityUtil.getClosestTo((Entity)this.animal, entities);
    }

    private boolean filterEntities(AnimalEntity entity) {
        return breedPredicate.func_221015_a((LivingEntity)this.animal, (LivingEntity)entity) && this.animal.func_70878_b(entity);
    }
}

