/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import java.util.function.Supplier;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DisplayInfoBuilder {
    private ITextComponent title;
    private ITextComponent description;
    private ItemStack icon;
    private ResourceLocation background;
    private FrameType frame;
    private boolean showToast = true;
    private boolean announceToChat = true;
    private boolean hidden = false;

    public DisplayInfoBuilder translate(ResourceLocation key) {
        return this.translate(key.func_110624_b() + "." + key.func_110623_a());
    }

    public DisplayInfoBuilder translate(String key) {
        this.title((ITextComponent)new TranslationTextComponent("advancements." + key + ".title"));
        this.description((ITextComponent)new TranslationTextComponent("advancements." + key + ".description"));
        return this;
    }

    public DisplayInfoBuilder title(ITextComponent titleIn) {
        this.title = titleIn;
        return this;
    }

    public DisplayInfoBuilder description(ITextComponent descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    public DisplayInfoBuilder icon(Supplier<? extends IItemProvider> stackIn) {
        return this.icon(stackIn.get());
    }

    public DisplayInfoBuilder icon(IItemProvider provider) {
        return this.icon(new ItemStack((IItemProvider)provider.func_199767_j()));
    }

    public DisplayInfoBuilder icon(ItemStack stackIn) {
        this.icon = stackIn;
        return this;
    }

    public DisplayInfoBuilder background(String path) {
        return this.background(new ResourceLocation("textures/gui/advancements/backgrounds/" + path));
    }

    public DisplayInfoBuilder background(String modId, String path) {
        return this.background(new ResourceLocation(modId, "textures/gui/advancements/backgrounds/" + path));
    }

    public DisplayInfoBuilder background(ResourceLocation backgroundIn) {
        this.background = backgroundIn;
        return this;
    }

    public DisplayInfoBuilder frame(FrameType frameIn) {
        this.frame = frameIn;
        return this;
    }

    public DisplayInfoBuilder noToast() {
        this.showToast = false;
        return this;
    }

    public DisplayInfoBuilder noAnnouncement() {
        this.announceToChat = false;
        return this;
    }

    public DisplayInfoBuilder hide() {
        this.hidden = true;
        return this;
    }

    public DisplayInfo build() {
        return new DisplayInfo(this.icon, this.title, this.description, this.background, this.frame, this.showToast, this.announceToChat, this.hidden);
    }

    public static DisplayInfoBuilder create() {
        return new DisplayInfoBuilder();
    }
}

