/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModel;
import doggytalents.client.entity.render.RenderUtil;
import doggytalents.client.entity.render.layer.BoneLayer;
import doggytalents.client.entity.render.layer.DogAccessoryLayer;
import doggytalents.client.entity.render.layer.DogTalentLayer;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.DogEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DogRenderer
extends MobRenderer<DogEntity, DogModel<DogEntity>> {
    public DogRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new DogModel(), 0.5f);
        this.func_177094_a(new DogTalentLayer((IEntityRenderer<DogEntity, DogModel<DogEntity>>)this));
        this.func_177094_a(new DogAccessoryLayer((IEntityRenderer<DogEntity, DogModel<DogEntity>>)this));
        this.func_177094_a(new BoneLayer(this));
    }

    protected float getBob(DogEntity livingBase, float partialTicks) {
        return livingBase.getTailRotation();
    }

    public void render(DogEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double d0;
        if (entityIn.isDogWet()) {
            float f = entityIn.getShadingWhileWet(partialTicks);
            ((DogModel)this.field_77045_g).func_228253_a_(f, f, f);
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (this.func_177070_b((MobEntity)entityIn) && (d0 = this.field_76990_c.func_229099_b_((Entity)entityIn)) <= 4096.0) {
            String tip = entityIn.getMode().getTip();
            String label = String.format(ConfigValues.DOG_GENDER ? "%s(%d)%s" : "%s(%d)", new TranslationTextComponent(tip).getString(), MathHelper.func_76123_f((float)entityIn.getDogHunger()), new TranslationTextComponent(entityIn.getGender().getUnlocalisedTip()).getString());
            RenderUtil.renderLabelWithScale(entityIn, this, label, matrixStackIn, bufferIn, packedLightIn, 0.01f, 0.12f);
            if (d0 <= 25.0 && this.field_76990_c.field_217783_c.func_216773_g().func_225608_bj_()) {
                RenderUtil.renderLabelWithScale(entityIn, this, entityIn.getOwnersName().orElseGet(() -> this.getNameUnknown(entityIn)), matrixStackIn, bufferIn, packedLightIn, 0.01f, -0.25f);
            }
        }
        if (entityIn.isDogWet()) {
            ((DogModel)this.field_77045_g).func_228253_a_(1.0f, 1.0f, 1.0f);
        }
    }

    private ITextComponent getNameUnknown(DogEntity dogIn) {
        return new TranslationTextComponent(dogIn.func_184753_b() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed");
    }

    public ResourceLocation getTextureLocation(DogEntity dogIn) {
        return DogTextureManager.INSTANCE.getTexture(dogIn);
    }

    protected void scale(DogEntity dogIn, MatrixStack matrixStackIn, float partialTickTime) {
        float size = (float)dogIn.getDogSize() * 0.3f + 0.1f;
        matrixStackIn.func_227862_a_(size, size, size);
        this.field_76989_e = size * 0.5f;
    }
}

