/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.google.common.collect.Maps;
import doggytalents.api.client.render.IAccessoryRenderer;
import doggytalents.api.client.render.ITalentRenderer;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IRegistryDelegate;

public class CollarRenderManager {
    private static Map<IRegistryDelegate<Accessory>, IAccessoryRenderer<?>> accessoryRendererMap = Maps.newConcurrentMap();
    private static Map<IRegistryDelegate<Talent>, ITalentRenderer<?>> talentRendererMap = Maps.newConcurrentMap();

    public static void registerRenderer(Supplier<? extends Accessory> entityClass, IAccessoryRenderer<?> shader) {
        CollarRenderManager.registerRenderer(entityClass.get(), shader);
    }

    public static void registerRenderer(Accessory entityClass, IAccessoryRenderer<?> shader) {
        accessoryRendererMap.put((IRegistryDelegate<Accessory>)entityClass.delegate, shader);
    }

    public static void registerRenderer(Supplier<? extends Talent> entityClass, ITalentRenderer<?> shader) {
        CollarRenderManager.registerRenderer(entityClass.get(), shader);
    }

    public static void registerRenderer(Talent entityClass, ITalentRenderer<?> shader) {
        talentRendererMap.put((IRegistryDelegate<Talent>)entityClass.delegate, shader);
    }

    public static boolean hasRenderer(Accessory type) {
        return accessoryRendererMap.containsKey(type.delegate);
    }

    @Nullable
    public static IAccessoryRenderer<?> getRendererFor(Accessory type) {
        return accessoryRendererMap.get(type.delegate);
    }

    @Nullable
    public static ITalentRenderer<?> getRendererFor(Talent talent) {
        return talentRendererMap.get(talent.delegate);
    }
}

