/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyTalents2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class CachedFileTexture
extends SimpleTexture {
    private File cacheFile;
    private boolean textureUploaded;

    public CachedFileTexture(ResourceLocation rlIn, File cacheFileIn) {
        super(rlIn);
        this.cacheFile = cacheFileIn;
    }

    private void setImage(NativeImage nativeImageIn) {
        Minecraft.func_71410_x().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        Minecraft.func_71410_x().execute(() -> {
            if (!this.textureUploaded) {
                NativeImage nativeimage = null;
                if (this.cacheFile.isFile() && this.cacheFile.exists()) {
                    DoggyTalents2.LOGGER.debug("Loading dog texture from local cache ({})", (Object)this.cacheFile);
                    FileInputStream fileinputstream = null;
                    try {
                        fileinputstream = new FileInputStream(this.cacheFile);
                        nativeimage = this.loadTexture(fileinputstream);
                    }
                    catch (FileNotFoundException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fileinputstream);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)fileinputstream);
                    }
                    IOUtils.closeQuietly((InputStream)fileinputstream);
                }
                if (nativeimage != null) {
                    this.setImage(nativeimage);
                } else {
                    DoggyTalents2.LOGGER.warn("Was unable to set image ({})", (Object)this.cacheFile);
                }
            }
        });
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.func_195713_a((InputStream)inputStreamIn);
        }
        catch (IOException ioexception) {
            DoggyTalents2.LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }
}

