/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryType;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IRegistryDelegate;

public class AccessoryInstance {
    public static final byte RENDER_TOP = 1;
    public static final byte RENDER_BOTTOM = -1;
    public static final byte RENDER_DEFAULT = 0;
    public static final Comparator<AccessoryInstance> RENDER_SORTER = Comparator.comparing(AccessoryInstance::getRenderIndex);
    @Deprecated
    private final Accessory accessory;

    public AccessoryInstance(Accessory typeIn) {
        this.accessory = typeIn;
    }

    public Accessory getAccessory() {
        return this.accessory;
    }

    public <T extends Accessory> boolean of(Supplier<T> accessoryIn) {
        return this.accessory.of(accessoryIn);
    }

    public <T extends Accessory> boolean of(T accessoryIn) {
        return this.accessory.of(accessoryIn);
    }

    public <T extends Accessory> boolean of(IRegistryDelegate<T> accessoryDelegateIn) {
        return this.accessory.of(accessoryDelegateIn);
    }

    public <T extends AccessoryType> boolean ofType(Supplier<T> accessoryTypeIn) {
        return this.ofType((AccessoryType)((Object)accessoryTypeIn.get()));
    }

    public <T extends AccessoryType> boolean ofType(T accessoryTypeIn) {
        return this.ofType(accessoryTypeIn.delegate);
    }

    public <T extends AccessoryType> boolean ofType(IRegistryDelegate<T> accessoryTypeDelegateIn) {
        return accessoryTypeDelegateIn.equals((Object)this.accessory.getType().delegate);
    }

    public AccessoryInstance copy() {
        return new AccessoryInstance(this.accessory);
    }

    public ItemStack getReturnItem() {
        return this.getAccessory().getReturnItem(this);
    }

    public byte getRenderIndex() {
        return this.getAccessory().getRenderLayer();
    }

    public final void writeInstance(CompoundNBT compound) {
        ResourceLocation rl = this.getAccessory().getRegistryName();
        if (rl != null) {
            compound.func_74778_a("type", rl.toString());
        }
        this.getAccessory().write(this, compound);
    }

    public static Optional<AccessoryInstance> readInstance(CompoundNBT compound) {
        ResourceLocation rl = null;
        try {
            rl = ResourceLocation.func_208304_a((String)compound.func_74779_i("type"));
            if (DoggyTalentsAPI.ACCESSORIES.containsKey(rl)) {
                Accessory type = (Accessory)DoggyTalentsAPI.ACCESSORIES.getValue(rl);
                return Optional.of(type.read(compound));
            }
            DoggyTalentsAPI.LOGGER.warn("Failed to load accessory {}", (Object)compound);
        }
        catch (Exception e) {
            DoggyTalentsAPI.LOGGER.warn("Failed to load accessory {}", (Object)rl);
        }
        return Optional.empty();
    }

    public <T extends AccessoryInstance> T cast(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }
}

