/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.impl;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.ICasingMaterial;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CasingMaterial
extends ICasingMaterial {
    private final Supplier<Block> block;
    protected ResourceLocation texture;
    @Nullable
    private String translationKey;

    public CasingMaterial(Supplier<Block> blockIn) {
        this.block = blockIn;
    }

    public CasingMaterial(Supplier<Block> blockIn, ResourceLocation texture) {
        this.block = blockIn;
        this.texture = texture;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            ResourceLocation loc = this.block.get().getRegistryName();
            this.texture = new ResourceLocation(loc.func_110624_b(), "block/" + loc.func_110623_a());
        }
        return this.texture;
    }

    @Override
    public ITextComponent getTooltip() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"dogbed.casing", (ResourceLocation)DoggyTalentsAPI.CASING_MATERIAL.getKey((IForgeRegistryEntry)this));
        }
        return new TranslationTextComponent(this.translationKey);
    }

    @Override
    public Ingredient getIngredient() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)this.block.get()});
    }
}

