/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.trees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import therealeststu.dtbop.cells.DTBOPLeafClusters;

public class PoplarSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = PoplarSpecies.createDefaultType(PoplarSpecies::new);

    public PoplarSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return new NodeInflatorPoplar(this, leafMap);
    }

    public class NodeInflatorPoplar
    implements NodeInspector {
        private float radius;
        private BlockPos last;
        Species species;
        SimpleVoxmap leafMap;

        public NodeInflatorPoplar(Species species, SimpleVoxmap leafMap) {
            this.species = species;
            this.leafMap = leafMap;
            this.last = BlockPos.field_177992_a;
        }

        public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
            BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
            if (branch != null) {
                this.radius = this.species.getFamily().getPrimaryThickness();
            }
            return false;
        }

        public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
            BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
            if (branch != null) {
                SimpleVoxmap leafCluster;
                float areaAccum = this.radius * this.radius;
                boolean isTwig = true;
                boolean isTop = world.func_180495_p(pos.func_177977_b()).func_177230_c() == branch;
                for (Direction dir : Direction.values()) {
                    if (dir.equals((Object)fromDir)) continue;
                    BlockPos dPos = pos.func_177971_a(dir.func_176730_m());
                    if (dPos.equals((Object)this.last)) {
                        isTwig = false;
                        isTop = false;
                        continue;
                    }
                    BlockState deltaBlockState = world.func_180495_p(dPos);
                    TreePart treepart = TreeHelper.getTreePart((BlockState)deltaBlockState);
                    if (!branch.isSameTree(treepart)) continue;
                    int branchRadius = treepart.getRadius(deltaBlockState);
                    areaAccum += (float)(branchRadius * branchRadius);
                }
                if (isTop) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = DTBOPLeafClusters.POPLAR_TOP;
                    this.leafMap.blitMax(pos, leafCluster);
                } else if (isTwig) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                } else {
                    float secondaryThickness;
                    this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                    int maxRadius = this.species.getMaxBranchRadius();
                    if (this.radius > (float)maxRadius) {
                        this.radius = maxRadius;
                    }
                    if (this.radius < (secondaryThickness = (float)this.species.getFamily().getSecondaryThickness())) {
                        this.radius = secondaryThickness;
                    }
                    branch.setRadius(world, pos, (int)Math.floor(this.radius), null);
                    this.leafMap.setVoxel(pos, (byte)32);
                    if (Math.floor(this.radius) < 3.0) {
                        SimpleVoxmap leafCluster2 = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                        this.leafMap.blitMax(pos, leafCluster2);
                    }
                }
                this.last = pos;
            }
            return false;
        }
    }
}

