/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.models;

import com.ferreusveritas.dynamictrees.blocks.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class PalmLeavesBakedModel
implements IDynamicBakedModel {
    public static List<PalmLeavesBakedModel> INSTANCES = new ArrayList<PalmLeavesBakedModel>();
    protected final BlockModel blockModel;
    ResourceLocation frondsResLoc;
    TextureAtlasSprite frondsTexture;
    private final IBakedModel[] bakedFronds = new IBakedModel[8];

    public PalmLeavesBakedModel(ResourceLocation modelResLoc, ResourceLocation frondsResLoc) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), false, BlockModel.GuiLight.FRONT, ItemCameraTransforms.field_178357_a, (List)ItemOverrideList.field_188022_a.getOverrides());
        this.frondsResLoc = frondsResLoc;
        INSTANCES.add(this);
    }

    public void setupModels() {
        this.frondsTexture = ModelUtils.getTexture((ResourceLocation)this.frondsResLoc);
        for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(this.frondsTexture);
            BlockVertexData[] quadData = new BlockVertexData[]{new BlockVertexData(0.0f, 0.0f, 3.0f, 15.0f, 4.0f), new BlockVertexData(0.0f, 1.0f, 3.0f, 15.0f, 0.0f), new BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 4.0f), new BlockVertexData(0.0f, 0.0f, 3.0f, 15.0f, 4.0f), new BlockVertexData(0.0f, 0.0f, 0.0f, 0.0f, 4.0f), new BlockVertexData(0.0f, 1.0f, 0.0f, 0.0f, 0.0f), new BlockVertexData(0.0f, 1.0f, 3.0f, 15.0f, 0.0f)};
            for (int pass = 0; pass < 3; ++pass) {
                for (int half = 0; half < 2; ++half) {
                    BlockVertexData[] outData = new BlockVertexData[8];
                    for (int v = 0; v < 8; ++v) {
                        double mult;
                        float x = quadData[v].x;
                        float z = quadData[v].z;
                        float y = quadData[v].y;
                        double len = 0.75 - (double)y;
                        double angle = Math.atan2(x *= 1.25f, y);
                        x = (float)(Math.sin(angle += Math.PI * (half == 1 ? 0.8 : -0.8)) * len);
                        y = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(y * y + (z *= 1.25f) * z);
                        angle = Math.atan2(y, z);
                        switch (pass) {
                            case 0: {
                                mult = -0.17;
                                break;
                            }
                            case 1: {
                                mult = 0.06;
                                break;
                            }
                            case 2: {
                                mult = 0.28;
                                break;
                            }
                            default: {
                                mult = 0.0;
                            }
                        }
                        y = (float)(Math.sin(angle += Math.PI * mult) * len);
                        z = (float)(Math.cos(angle) * len);
                        len = Math.sqrt(x * x + z * z);
                        angle = Math.atan2(x, z);
                        switch (pass) {
                            default: {
                                mult = 0.0;
                                break;
                            }
                            case 1: {
                                mult = -0.065;
                                break;
                            }
                            case 2: {
                                mult = 0.08;
                            }
                        }
                        x = (float)(Math.sin(angle += 0.7853981633974483 * (double)surr.ordinal() + Math.PI * mult) * len);
                        z = (float)(Math.cos(angle) * len);
                        x += 0.5f;
                        z += 0.5f;
                        switch (pass) {
                            case 0: {
                                y = (float)((double)y + 0.125);
                                break;
                            }
                            case 2: {
                                y = (float)((double)y + -0.125);
                                break;
                            }
                            default: {
                                y += 0.0f;
                            }
                        }
                        outData[v] = new BlockVertexData(x += (float)surr.getOffset().func_177958_n(), y, z += (float)surr.getOffset().func_177952_p(), quadData[v].u, quadData[v].v);
                    }
                    int[] vertices = Ints.concat((int[][])new int[][]{outData[0].toInts(this.frondsTexture), outData[1].toInts(this.frondsTexture), outData[2].toInts(this.frondsTexture), outData[3].toInts(this.frondsTexture)});
                    builder.func_177648_a(new BakedQuad(vertices, 0, FaceBakery.func_178410_a((int[])vertices), this.frondsTexture, false));
                    vertices = Ints.concat((int[][])new int[][]{outData[4].toInts(this.frondsTexture), outData[5].toInts(this.frondsTexture), outData[6].toInts(this.frondsTexture), outData[7].toInts(this.frondsTexture)});
                    builder.func_177648_a(new BakedQuad(vertices, 0, FaceBakery.func_178410_a((int[])vertices), this.frondsTexture, false));
                    this.bakedFronds[surr.ordinal()] = builder.func_177645_b();
                }
            }
        }
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        int direction = (Integer)state.func_177229_b((Property)PalmLeavesProperties.DynamicPalmLeavesBlock.DIRECTION);
        if (direction != 0) {
            quads.addAll(this.bakedFronds[direction - 1].getQuads(state, null, rand, extraData));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.frondsTexture;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean doesHandlePerspectives() {
        return false;
    }

    public static class BlockVertexData {
        public float x;
        public float y;
        public float z;
        public int color;
        public float u;
        public float v;

        public BlockVertexData(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
            this.color = -1;
        }

        public BlockVertexData(BakedQuad quad, int vIndex) {
            this(quad.func_178209_a(), vIndex);
        }

        public BlockVertexData(int[] data, int vIndex) {
            vIndex *= 8;
            this.x = Float.intBitsToFloat(data[vIndex++]);
            this.y = Float.intBitsToFloat(data[vIndex++]);
            this.z = Float.intBitsToFloat(data[vIndex++]);
            this.color = data[vIndex++];
            this.u = Float.intBitsToFloat(data[vIndex++]);
            this.v = Float.intBitsToFloat(data[vIndex]);
        }

        public int[] toInts() {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(this.u), Float.floatToRawIntBits(this.v), 0, 0};
        }

        protected int[] toInts(TextureAtlasSprite texture) {
            return new int[]{Float.floatToRawIntBits(this.x), Float.floatToRawIntBits(this.y), Float.floatToRawIntBits(this.z), this.color, Float.floatToRawIntBits(texture.func_94214_a((double)this.u)), Float.floatToRawIntBits(texture.func_94207_b((double)this.v)), 0, 0};
        }
    }
}

