/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RedwoodLogic
extends GrowthLogicKit {
    public RedwoodLogic(ResourceLocation registryName) {
        super(registryName);
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        World world = context.world();
        BlockPos pos = context.pos();
        Species species = context.species();
        GrowSignal signal = context.signal();
        Direction originDir = signal.dir.func_176734_d();
        int signalY = signal.delta.func_177956_o();
        if (signal.numSteps + 1 <= configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) {
            return Direction.UP;
        }
        int[] probMap = new int[6];
        probMap[Direction.UP.ordinal()] = signal.dir != Direction.DOWN ? species.getUpProbability() : 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + species.getProbabilityForCurrentDir();
        int radius = context.branch().getRadius(world.func_180495_p(pos));
        if (signal.delta.func_177956_o() < configuration.getLowestBranchHeight((PositionalSpeciesContext)context) - 3) {
            boolean sideTurn;
            int treeHash = this.getHashedVariation(world, signal.rootPos, 2);
            int posHash = this.getHashedVariation(world, pos, 2);
            int hashMod = signalY < 7 ? 3 : 11;
            boolean bl = sideTurn = !signal.isInTrunk() || signal.isInTrunk() && (signal.numSteps + treeHash) % hashMod == 0 && radius > 1;
            if (!sideTurn) {
                return Direction.UP;
            }
            probMap[2 + posHash % 4] = 1;
        }
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            BlockPos deltaPos = pos.func_177971_a(dir.func_176730_m());
            if (signalY < configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) continue;
            BlockState deltaBlockState = world.func_180495_p(deltaPos);
            TreePart treePart = TreeHelper.getTreePart((BlockState)deltaBlockState);
            int n2 = dir.ordinal();
            probMap[n2] = probMap[n2] + treePart.probabilityForBlock(deltaBlockState, (IBlockReader)world, deltaPos, context.branch());
        }
        probMap = configuration.populateDirectionProbabilityMap(new DirectionManipulationContext(context.world(), context.pos(), context.species(), context.branch(), context.signal(), context.branch().getRadius(context.world().func_180495_p(context.pos())), probMap));
        int choice = MathHelper.selectRandomFromDistribution((Random)signal.rand, (int[])probMap);
        return this.newDirectionSelected(configuration, context, Direction.values()[choice != -1 ? choice : 1]);
    }

    private Direction newDirectionSelected(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context, Direction newDir) {
        GrowSignal signal = context.signal();
        if (signal.isInTrunk() && newDir != Direction.UP) {
            int signalY = signal.delta.func_177956_o();
            if (signalY < configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) {
                signal.energy = 0.9f + (1.0f - (float)signalY / (float)configuration.getLowestBranchHeight((PositionalSpeciesContext)context)) * 3.7f;
            } else {
                signal.energy += 5.0f;
                signal.energy /= 4.8f;
                if (signal.energy > 5.8f) {
                    signal.energy = 5.8f;
                }
            }
        }
        return newDir;
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.func_176734_d();
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() || signal.delta.func_177956_o() >= configuration.getLowestBranchHeight((PositionalSpeciesContext)context) ? context.species().getUpProbability() : 1;
        probMap[originDir.ordinal()] = 0;
        if (signal.numTurns == 1 && signal.delta.func_218140_a(0.0, (double)signal.delta.func_177956_o(), 0.0, true) == 1.0) {
            probMap[1] = 0;
        }
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        World world = context.world();
        BlockPos pos = context.pos();
        Species species = context.species();
        return species.getSignalEnergy() * species.biomeSuitability(world, pos) + this.getHashedVariation(world, pos, 2, 16);
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        World world = context.world();
        BlockPos pos = context.pos();
        return (int)(((float)super.getLowestBranchHeight(configuration, context) + this.getHashedVariation(world, pos, 2, 16) * 0.5f) * context.species().biomeSuitability(world, pos));
    }

    private int getHashedVariation(World world, BlockPos pos, int readyMade) {
        long day = world.func_82737_E() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)readyMade);
    }

    private float getHashedVariation(World world, BlockPos pos, int readyMade, Integer mod) {
        return this.getHashedVariation(world, pos, readyMade) % mod;
    }
}

