/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PoplarLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Boolean> LARGE = ConfigurationProperty.bool((String)"large");

    public PoplarLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(LARGE, (Object)false);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{LARGE});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.func_176734_d();
        probMap[0] = signal.isInTrunk() ? 0 : 1;
        probMap[1] = signal.isInTrunk() ? context.species().getUpProbability() : 1;
        probMap[5] = signal.isInTrunk() && signal.numSteps % 2 == 0 || !signal.isInTrunk() ? 2 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        probMap[originDir.ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction direction = super.selectNewDirection(configuration, context);
        GrowSignal signal = context.signal();
        boolean large = (Boolean)configuration.get(LARGE);
        if (signal.isInTrunk() && direction != Direction.UP) {
            signal.energy = large && signal.energy >= 12.0f ? 1.8f : (large && signal.energy >= 7.0f ? 2.8f : (signal.energy >= 4.0f ? 1.8f : 0.8f));
        }
        return direction;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getSignalEnergy() + this.getHashedVariation(context.world(), context.pos(), 3);
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + this.getHashedVariation(context.world(), context.pos(), 3));
    }

    private float getHashedVariation(World world, BlockPos pos, int mod) {
        long day = world.func_82737_E() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)2) % mod;
    }
}

