/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class ExtraBottomFlareGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"min_radius");
    public static final ConfigurationProperty<Integer> SECONDARY_MIN_RADIUS = ConfigurationProperty.integer((String)"secondary_min_radius");

    public ExtraBottomFlareGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MIN_RADIUS, SECONDARY_MIN_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_RADIUS, (Object)6)).with(SECONDARY_MIN_RADIUS, (Object)8);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() > 0) {
            this.flareBottom(configuration, context.world(), context.pos(), context.species());
            return true;
        }
        return false;
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        this.flareBottom(configuration, context.world(), context.pos(), context.species());
        return true;
    }

    public void flareBottom(GenFeatureConfiguration configuredGenFeature, IWorld world, BlockPos rootPos, Species species) {
        species.getFamily().getBranch().ifPresent(branch -> {
            int radius4 = TreeHelper.getRadius((IBlockReader)world, (BlockPos)rootPos.func_177981_b(4));
            if (radius4 > (Integer)configuredGenFeature.get(SECONDARY_MIN_RADIUS)) {
                branch.setRadius(world, rootPos.func_177981_b(3), radius4 + 1, Direction.UP);
                branch.setRadius(world, rootPos.func_177981_b(2), radius4 + 3, Direction.UP);
                branch.setRadius(world, rootPos.func_177981_b(1), radius4 + 6, Direction.UP);
            } else {
                int radius3 = TreeHelper.getRadius((IBlockReader)world, (BlockPos)rootPos.func_177981_b(3));
                if (radius3 > (Integer)configuredGenFeature.get(MIN_RADIUS)) {
                    branch.setRadius(world, rootPos.func_177981_b(2), radius3 + 1, Direction.UP);
                    branch.setRadius(world, rootPos.func_177981_b(1), radius3 + 2, Direction.UP);
                }
            }
        });
    }
}

