/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop.cells;

import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.cells.NormalCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import therealeststu.dtbop.cells.DTBOPLeafClusters;
import therealeststu.dtbop.cells.cell.EucalyptusLeafCell;
import therealeststu.dtbop.cells.cell.EucalyptusTopBranchCell;
import therealeststu.dtbop.cells.cell.HellbarkLeafCell;
import therealeststu.dtbop.cells.cell.MahoganyBranchCell;
import therealeststu.dtbop.cells.cell.MahoganyLeafCell;
import therealeststu.dtbop.cells.cell.PoplarBranchCell;
import therealeststu.dtbop.cells.cell.PoplarLeafCell;
import therealeststu.dtbop.cells.cell.PoplarTopBranchCell;
import therealeststu.dtbop.cells.cell.SparseBranchCell;

public class DTBOPCellKits {
    public static final CellKit SPARSE = new SparseCellKit(new ResourceLocation("dtbop", "sparse"));
    public static final CellKit HELLBARK_SPARSE = new SparseCellKit(new ResourceLocation("dtbop", "hellbark_sparse")){

        @Override
        public Cell getCellForBranch(int radius, int meta) {
            return radius <= 3 ? this.sparseBranch : CellNull.NULL_CELL;
        }
    };
    public static final CellKit POPLAR = new CellKit(new ResourceLocation("dtbop", "poplar")){
        private final Cell poplarBranch = new PoplarBranchCell();
        private final Cell poplarTopBranch = new PoplarTopBranchCell();
        private final Cell poplarUpperTrunk = new NormalCell(4);
        private final Cell[] poplarLeaves = new Cell[]{CellNull.NULL_CELL, new PoplarLeafCell(1), new PoplarLeafCell(2), new PoplarLeafCell(3), new PoplarLeafCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1042, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.poplarLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.poplarTopBranch;
            }
            if (radius == 1) {
                return this.poplarBranch;
            }
            if (radius < 4) {
                return this.poplarUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.POPLAR;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit MAHOGANY = new CellKit(new ResourceLocation("dtbop", "mahogany")){
        private final Cell mahoganyBranch = new MahoganyBranchCell();
        private final Cell[] mahoganyLeafCells = new Cell[]{CellNull.NULL_CELL, new MahoganyLeafCell(1), new MahoganyLeafCell(2), new MahoganyLeafCell(3), new MahoganyLeafCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1299, 1043, 802, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.mahoganyLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (radius == 1) {
                return this.mahoganyBranch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.MAHOGANY;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 3;
        }
    };
    public static final CellKit BRUSH = new CellKit(new ResourceLocation("dtbop", "brush")){
        private final Cell branch = new Cell(){
            final int[] map = new int[]{3, 3, 5, 5, 5, 5};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] normalCells = new Cell[]{CellNull.NULL_CELL, new NormalCell(1), new NormalCell(2), new NormalCell(3), new NormalCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1299, 1042, 802, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (radius == 1) {
                return this.branch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.BRUSH;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 3;
        }
    };
    public static final CellKit EUCALYPTUS = new CellKit(new ResourceLocation("dtbop", "eucalyptus")){
        private final Cell eucalyptusTopBranch = new EucalyptusTopBranchCell();
        private final Cell eucalyptusBranch = new NormalCell(2);
        private final Cell eucalyptusUpperTrunk = new NormalCell(3);
        private final Cell[] eucalyptusLeaves = new Cell[]{CellNull.NULL_CELL, new EucalyptusLeafCell(1), new EucalyptusLeafCell(2), new EucalyptusLeafCell(3), new EucalyptusLeafCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1300, 1059, 1041, 786, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.eucalyptusLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.eucalyptusTopBranch;
            }
            if (radius == 1) {
                return this.eucalyptusBranch;
            }
            if (radius <= 3) {
                return this.eucalyptusUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.EUCALYPTUS;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit HELLBARK = new CellKit(new ResourceLocation("dtbop", "hellbark")){
        private final Cell hellbarkBranch = new Cell(){
            final int[] map = new int[]{0, 7, 5, 5, 5, 5};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] hellbarkLeafCells = new Cell[]{CellNull.NULL_CELL, new HellbarkLeafCell(1), new HellbarkLeafCell(2), new HellbarkLeafCell(3), new HellbarkLeafCell(4), new HellbarkLeafCell(5), new HellbarkLeafCell(6), new HellbarkLeafCell(7)};
        private final CellKits.BasicSolver hellbarkSolver = new CellKits.BasicSolver(new short[]{1814, 1557, 1300, 1059, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.hellbarkLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius <= 4 ? this.hellbarkBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.HELLBARK;
        }

        public CellSolver getCellSolver() {
            return this.hellbarkSolver;
        }

        public int getDefaultHydration() {
            return 6;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{SPARSE, POPLAR, MAHOGANY, BRUSH, EUCALYPTUS, HELLBARK, HELLBARK_SPARSE});
    }

    public static class SparseCellKit
    extends CellKit {
        protected final Cell sparseBranch = new SparseBranchCell();
        protected final Cell sparseLeaves = new NormalCell(1);
        protected final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public SparseCellKit(ResourceLocation registryName) {
            super(registryName);
        }

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBOPLeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    }
}

