/*
 * Decompiled with CFR 0.152.
 */
package therealeststu.dtbop;

import biomesoplenty.api.biome.BOPBiomes;
import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.BeeNestGenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import therealeststu.dtbop.blocks.leaves.CobwebLeavesProperties;
import therealeststu.dtbop.cells.DTBOPCellKits;
import therealeststu.dtbop.genfeature.DTBOPGenFeatures;
import therealeststu.dtbop.growthlogic.DTBOPGrowthLogicKits;
import therealeststu.dtbop.trees.Bush;
import therealeststu.dtbop.trees.CypressSpecies;
import therealeststu.dtbop.trees.GenOnStoneSpecies;
import therealeststu.dtbop.trees.MapleSpecies;
import therealeststu.dtbop.trees.PoplarSpecies;
import therealeststu.dtbop.trees.TwigletSpecies;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTBOPRegistries {
    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        DTBOPGenFeatures.register((com.ferreusveritas.dynamictrees.api.registry.Registry<GenFeature>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        DTBOPGrowthLogicKits.register((com.ferreusveritas.dynamictrees.api.registry.Registry<GrowthLogicKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        DTBOPCellKits.register((com.ferreusveritas.dynamictrees.api.registry.Registry<CellKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
        event.registerType(new ResourceLocation("dtbop", "cobweb"), CobwebLeavesProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(new ResourceLocation("dtbop", "twiglet"), TwigletSpecies.TYPE);
        event.registerType(new ResourceLocation("dtbop", "poplar"), PoplarSpecies.TYPE);
        event.registerType(new ResourceLocation("dtbop", "cypress"), CypressSpecies.TYPE);
        event.registerType(new ResourceLocation("dtbop", "maple"), MapleSpecies.TYPE);
        event.registerType(new ResourceLocation("dtbop", "generates_on_stone"), GenOnStoneSpecies.TYPE);
    }

    @SubscribeEvent
    public static void registerSpecies(RegistryEvent<Species> event) {
        event.getRegistry().registerAll((RegistryEntry[])new Species[]{new Bush("flowering_oak_bush", new ResourceLocation("oak_log"), new ResourceLocation("oak_leaves"), new ResourceLocation("biomesoplenty", "flowering_oak_leaves"))});
        event.getRegistry().registerAll((RegistryEntry[])new Species[]{new Bush("oak_bush", new ResourceLocation("oak_log"), new ResourceLocation("oak_leaves"))});
        event.getRegistry().registerAll((RegistryEntry[])new Species[]{new Bush("infested_oak_bush", new ResourceLocation("oak_log"), new ResourceLocation("oak_leaves"), new ResourceLocation("cobweb"))});
        event.getRegistry().registerAll((RegistryEntry[])new Species[]{new Bush("silk_bush", new ResourceLocation("oak_log"), new ResourceLocation("cobweb"))});
        event.getRegistry().registerAll((RegistryEntry[])new Species[]{new Bush("acacia_bush", new ResourceLocation("acacia_log"), new ResourceLocation("acacia_leaves")).addAcceptableSoils(new String[]{"sand_like"})});
        event.getRegistry().registerAll((RegistryEntry[])new Species[]{new Bush("spruce_bush", new ResourceLocation("spruce_log"), new ResourceLocation("spruce_leaves"))});
    }

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
        Bush.INSTANCES.forEach(Bush::setup);
        Species floweringOak = (Species)Species.REGISTRY.get(new ResourceLocation("dtbop", "flowering_oak"));
        Species floweringAppleOak = (Species)Species.REGISTRY.get(new ResourceLocation("dtbop", "flowering_apple_oak"));
        Species infested = (Species)Species.REGISTRY.get(new ResourceLocation("dtbop", "infested"));
        Species rainbowBirch = (Species)Species.REGISTRY.get(new ResourceLocation("dtbop", "rainbow_birch"));
        LeavesProperties floweringLeaves = (LeavesProperties)LeavesProperties.REGISTRY.get(new ResourceLocation("dtbop", "flowering_oak"));
        if (floweringOak.isValid() && floweringLeaves.isValid()) {
            floweringLeaves.setFamily(floweringOak.getFamily());
            floweringOak.addValidLeafBlocks(new LeavesProperties[]{floweringLeaves});
        }
        if (floweringAppleOak.isValid() && floweringLeaves.isValid()) {
            floweringAppleOak.addValidLeafBlocks(new LeavesProperties[]{floweringLeaves});
        }
        if (infested.isValid()) {
            LeavesProperties silkLeaves = (LeavesProperties)LeavesProperties.REGISTRY.get(new ResourceLocation("dtbop", "silk"));
            infested.addValidLeafBlocks(new LeavesProperties[]{silkLeaves});
        }
        if (rainbowBirch.isValid()) {
            rainbowBirch.addGenFeature((GenFeatureConfiguration)new BeeNestGenFeature(new ResourceLocation("dynamictrees", "bee_nest")).with(BeeNestGenFeature.WORLD_GEN_CHANCE_FUNCTION, (world, pos) -> {
                RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(world.func_225604_a_(pos.func_177958_n() >> 2, pos.func_177956_o() >> 2, pos.func_177952_p() >> 2).getRegistryName()));
                if (biomeKey == BOPBiomes.rainbow_hills) {
                    return 0.02;
                }
                return BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) ? 5.0E-4 : 0.0;
            }));
        }
    }
}

