/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry;

import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.architectury.registry.forge.ToolTypeImpl;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;

public final class ToolType {
    private static final Map<String, ToolType> TYPES = Maps.newConcurrentMap();
    public static final ToolType PICKAXE = ToolType.create("pickaxe", ToolType::pickaxeTag);
    public static final ToolType AXE = ToolType.create("axe", ToolType::axeTag);
    public static final ToolType HOE = ToolType.create("hoe", ToolType::hoeTag);
    public static final ToolType SHOVEL = ToolType.create("shovel", ToolType::shovelTag);
    public final String forgeName;
    public final Supplier<ITag<Item>> fabricTag;
    private Object obj;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ITag<Item> pickaxeTag() {
        return ToolTypeImpl.pickaxeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ITag<Item> axeTag() {
        return ToolTypeImpl.axeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ITag<Item> hoeTag() {
        return ToolTypeImpl.hoeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ITag<Item> shovelTag() {
        return ToolTypeImpl.shovelTag();
    }

    private ToolType(String forgeName, Supplier<ITag<Item>> fabricTag) {
        this.forgeName = forgeName;
        this.fabricTag = fabricTag;
    }

    public static ToolType create(String forgeName, Supplier<ITag<Item>> fabricTag) {
        return TYPES.computeIfAbsent(forgeName, s -> new ToolType((String)s, fabricTag));
    }

    public static ToolType byName(String forgeName) {
        return TYPES.get(forgeName);
    }
}

