/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.icetower;

import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.structures.icetower.IceTowerBridgeComponent;
import twilightforest.structures.icetower.IceTowerDecorator;
import twilightforest.structures.icetower.IceTowerEntranceComponent;
import twilightforest.structures.icetower.IceTowerPieces;
import twilightforest.structures.icetower.IceTowerWingComponent;

public class IceTowerMainComponent
extends IceTowerWingComponent {
    public boolean hasBossWing = false;

    public IceTowerMainComponent(TemplateManager manager, CompoundNBT nbt) {
        super(IceTowerPieces.TFITMai, nbt);
        this.hasBossWing = nbt.func_74767_n("hasBossWing");
    }

    public IceTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z) {
        this(feature, rand, index, x + 11, y + 40, z + 11, Direction.NORTH);
    }

    public IceTowerMainComponent(TFFeature feature, Random rand, int index, int x, int y, int z, Direction rotation) {
        super(IceTowerPieces.TFITMai, feature, index, x, y, z, 11, 31 + rand.nextInt(3) * 10, rotation);
        if (this.deco == null) {
            this.deco = new IceTowerDecorator();
        }
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74757_a("hasBossWing", this.hasBossWing);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        int length;
        super.func_74861_a(parent, list, rand);
        MutableBoundingBox towerBB = MutableBoundingBox.func_78887_a();
        for (StructurePiece structurecomponent : list) {
            towerBB.func_78888_b(structurecomponent.func_74874_b());
        }
        BlockPos myDoor = (BlockPos)this.openings.get(0);
        BlockPos entranceDoor = new BlockPos((Vector3i)myDoor);
        if (myDoor.func_177958_n() == 0 && (length = this.func_74874_b().field_78897_a - towerBB.field_78897_a) >= 0) {
            entranceDoor = entranceDoor.func_177985_f(length);
            this.makeEntranceBridge(list, rand, this.func_74877_c() + 1, myDoor.func_177958_n(), myDoor.func_177956_o(), myDoor.func_177952_p(), length, Rotation.CLOCKWISE_180);
        }
        if (myDoor.func_177958_n() == this.size - 1) {
            entranceDoor = entranceDoor.func_177965_g(towerBB.field_78893_d - this.func_74874_b().field_78893_d);
        }
        if (myDoor.func_177952_p() == 0) {
            entranceDoor = entranceDoor.func_177970_e(towerBB.field_78896_c - this.func_74874_b().field_78896_c);
        }
        if (myDoor.func_177958_n() == this.size - 1) {
            entranceDoor = entranceDoor.func_177970_e(towerBB.field_78892_f - this.func_74874_b().field_78892_f);
        }
        this.makeEntranceTower(list, rand, this.func_74877_c() + 1, entranceDoor.func_177958_n(), entranceDoor.func_177956_o(), entranceDoor.func_177952_p(), 11, 11, this.field_186169_c);
    }

    private void makeEntranceBridge(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int length, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, 5, direction);
        IceTowerBridgeComponent bridge = new IceTowerBridgeComponent(this.getFeatureType(), index, dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p(), length, direction);
        list.add(bridge);
        bridge.func_74861_a(list.get(0), list, rand);
    }

    public boolean makeEntranceTower(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        IceTowerEntranceComponent entrance = new IceTowerEntranceComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(entrance);
        ((IceTowerWingComponent)entrance).func_74861_a(list.get(0), list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }
}

