/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.DestroyArea;
import twilightforest.structures.finalcastle.FinalCastleFoundation13Component;
import twilightforest.structures.finalcastle.FinalCastleFoundation13ComponentThorns;
import twilightforest.structures.finalcastle.FinalCastleMazeTower13Component;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.structures.finalcastle.FinalCastleWreckedTowerComponent;

public class FinalCastleDamagedTowerComponent
extends FinalCastleMazeTower13Component {
    public FinalCastleDamagedTowerComponent(TemplateManager manager, CompoundNBT nbt) {
        this(FinalCastlePieces.TFFCDamT, nbt);
    }

    public FinalCastleDamagedTowerComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
    }

    public FinalCastleDamagedTowerComponent(IStructurePieceType piece, TFFeature feature, Random rand, int i, int x, int y, int z, Direction direction) {
        super(piece, feature, rand, i, x, y, z, ((Block)TFBlocks.castle_rune_brick_yellow.get()).func_176223_P(), direction);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        FinalCastleFoundation13Component foundation = new FinalCastleFoundation13Component(FinalCastlePieces.TFFCToF13, this.getFeatureType(), rand, 0, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        FinalCastleFoundation13ComponentThorns thorns = new FinalCastleFoundation13ComponentThorns(this.getFeatureType(), rand, 0, this);
        list.add(thorns);
        thorns.func_74861_a(this, list, rand);
        this.buildNonCriticalTowers(parent, list, rand);
    }

    @Override
    protected FinalCastleMazeTower13Component makeNewDamagedTower(Random rand, Direction facing, BlockPos tc) {
        return new FinalCastleWreckedTowerComponent(this.getFeatureType(), rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing);
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        super.func_230383_a_(world, manager, generator, rand, sbb, chunkPosIn, blockPos);
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.destroyTower(world, decoRNG, sbb);
        return true;
    }

    public void destroyTower(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        ArrayList<DestroyArea> areas = this.makeInitialDestroyList(rand);
        boolean hitDeadRock = false;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int y = this.field_74887_e.field_78894_e; !hitDeadRock && y > 64; --y) {
            for (int x = this.field_74887_e.field_78897_a - 2; x <= this.field_74887_e.field_78893_d + 2; ++x) {
                for (int z = this.field_74887_e.field_78896_c - 2; z <= this.field_74887_e.field_78892_f + 2; ++z) {
                    pos.func_181079_c(x, y, z);
                    if (!sbb.func_175898_b((Vector3i)pos)) continue;
                    if (world.func_180495_p((BlockPos)pos).func_177230_c() == TFBlocks.deadrock.get()) {
                        hitDeadRock = true;
                    }
                    this.determineBlockDestroyed(world, areas, y, x, z);
                }
            }
            DestroyArea removeArea = null;
            for (DestroyArea dArea : areas) {
                if (dArea != null && !dArea.isEntirelyAbove(y)) continue;
                removeArea = dArea;
            }
            if (removeArea == null) continue;
            areas.remove(removeArea);
            areas.add(DestroyArea.createNonIntersecting(this.func_74874_b(), rand, y, areas));
        }
    }

    protected ArrayList<DestroyArea> makeInitialDestroyList(Random rand) {
        ArrayList<DestroyArea> areas = new ArrayList<DestroyArea>(2);
        areas.add(DestroyArea.createNonIntersecting(this.func_74874_b(), rand, this.func_74874_b().field_78894_e - 1, areas));
        areas.add(DestroyArea.createNonIntersecting(this.func_74874_b(), rand, this.func_74874_b().field_78894_e - 1, areas));
        areas.add(DestroyArea.createNonIntersecting(this.func_74874_b(), rand, this.func_74874_b().field_78894_e - 1, areas));
        return areas;
    }

    protected void determineBlockDestroyed(ISeedReader world, ArrayList<DestroyArea> areas, int y, int x, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        for (DestroyArea dArea : areas) {
            if (dArea == null || !dArea.isVecInside(pos)) continue;
            world.func_217377_a(pos, false);
        }
    }
}

