/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.ie;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.DynamicShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseBalloon;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseBanner;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseChemthrower;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseRailgun;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseRevolver;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseShield;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.ARBShaderObjects;
import twilightforest.TwilightForestMod;
import twilightforest.client.shader.ShaderManager;
import twilightforest.client.shader.ShaderUniform;
import twilightforest.compat.ie.TFShaderCaseChemthrower;
import twilightforest.compat.ie.TFShaderCaseDrill;
import twilightforest.compat.ie.TFShaderCaseRailgun;
import twilightforest.compat.ie.TFShaderCaseShield;
import twilightforest.item.TFItems;

public class IEShaderRegister {
    private static final ShaderLayer NULL_LAYER = new ShaderLayer(null, -1);
    private static final ShaderLayer UNCOLORED_REVOLVER_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "revolvers/shaders/revolver_uncoloured"), -1);
    private static final ShaderLayer UNCOLORED_CHEMTHROW_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "item/shaders/chemthrower_uncoloured"), -1);
    private static final ShaderLayer UNCOLORED_DRILL_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "item/shaders/drill_diesel_uncoloured"), -1);
    private static final ShaderLayer UNCOLORED_RAILGUN_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "item/shaders/railgun_uncoloured"), -1);
    private static final ShaderLayer UNCOLORED_SHIELD_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "item/shaders/shield_uncoloured"), -1);
    private static final ShaderLayer UNCOLORED_MINECART_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "textures/models/shaders/minecart_uncoloured.png"), -1);
    private static final ShaderLayer UNCOLORED_BALLOON_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "block/shaders/balloon_uncoloured"), -1);
    private static final ShaderLayer UNCOLORED_BANNER_LAYER = new ShaderLayer(new ResourceLocation("immersiveengineering", "block/shaders/banner_uncoloured"), -1);
    public static final ResourceLocation PROCESSED_REVOLVER_GRIP_LAYER = new ResourceLocation("immersiveengineering", "revolvers/shaders/revolver_grip");
    public static final ResourceLocation PROCESSED_REVOLVER_LAYER = new ResourceLocation("immersiveengineering", "revolvers/shaders/revolver_0");
    public static final ResourceLocation PROCESSED_CHEMTHROW_LAYER = new ResourceLocation("immersiveengineering", "item/shaders/chemthrower_0");
    public static final ResourceLocation PROCESSED_DRILL_LAYER = new ResourceLocation("immersiveengineering", "item/shaders/drill_diesel_0");
    public static final ResourceLocation PROCESSED_RAILGUN_LAYER = new ResourceLocation("immersiveengineering", "item/shaders/railgun_0");
    public static final ResourceLocation PROCESSED_SHIELD_LAYER = new ResourceLocation("immersiveengineering", "item/shaders/shield_0");
    public static final ResourceLocation PROCESSED_BALLOON_LAYER = new ResourceLocation("immersiveengineering", "block/shaders/balloon_0");
    private static final ResourceLocation TEXTURE_STARS = new ResourceLocation("textures/entity/end_portal.png");
    private static final BiConsumer<IntConsumer, Boolean> TWILIGHT_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.twilightSkyShader, shaderCallback);
            ARBShaderObjects.glCreateShaderObjectARB((int)35667);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_STARS);
        } else {
            ShaderManager.releaseShader();
        }
        ARBShaderObjects.glCreateShaderObjectARB((int)35720);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
    };
    private static final BiConsumer<IntConsumer, Boolean> FIREFLY_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.fireflyShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final BiConsumer<IntConsumer, Boolean> CARMINITE_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.carminiteShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final BiConsumer<IntConsumer, Boolean> DEVICE_RED_ENERGY_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.towerDeviceShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final BiConsumer<IntConsumer, Boolean> DEVICE_YELLOW_ENERGY_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            GlStateManager.func_227692_c_((int)3553, (int)10240, (int)9729);
            ShaderManager.useShader(ShaderManager.yellowCircuitShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
            GlStateManager.func_227692_c_((int)3553, (int)10240, (int)9728);
        }
    };
    private static final BiConsumer<IntConsumer, Boolean> AURORA_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.auroraShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final BiConsumer<IntConsumer, Boolean> RAM_TRICONSUMER = (shaderCallback, pre) -> {
        if (pre.booleanValue()) {
            Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        } else {
            Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205109_c();
        }
    };
    private static final ShaderLayerProvider<?> LAYER_PROVIDER = (m, t, s, c) -> new ShaderLayer(m.provideTex(t, s), c);
    private static final ShaderLayerProvider<?> TOWER_DEVICE_SHADER_PROVIDER = (m, t, s, c) -> new ShaderConsumerLayer(ModType.TWILIGHT_FOREST.provideTex(t, "energy"), -1, DEVICE_RED_ENERGY_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS);
    private static final ShaderLayerProvider<?> YELLOW_CIRCUIT_SHADER_PROVIDER = (m, t, s, c) -> new ShaderConsumerLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "circuit"), -4526590, DEVICE_YELLOW_ENERGY_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS);
    private static List<ShaderRegistry.ShaderRegistryEntry> SHADERS;
    private static List<ShaderRegistry.ShaderRegistryEntry> NONBOSSES;
    private static final Rarity RARITY;

    public static void initShaders() {
        NONBOSSES = ImmutableList.of((Object)IEShaderRegister.registerShaderCases("Pinch Beetle", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -4418777, -14412279, -14412279, -12303292, LAYER_PROVIDER, (m, t, s, c) -> new ShaderLayer(m.provideTex(t, "1_6"), c)).setInfo("Twilight Forest", "Pinch Beetle", "pinch_beetle"), (Object)IEShaderRegister.registerShaderCases("Snakestone", ModType.TWILIGHT_FOREST, "streaks", RARITY, -6316129, -9934744, -10461088, -1, LAYER_PROVIDER, (m, t, s, c) -> new ShaderLayer(ModType.TWILIGHT_FOREST.provideTex(t, "scales"), -11513776), (m, t, s, c) -> new ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "circuit"), -10987432)).setInfo("Twilight Forest", "Nagastone", "courtyard"), (Object)IEShaderRegister.registerShaderCases("Mazestone", ModType.TWILIGHT_FOREST, "scales", RARITY, -7431794, -11511472, -9405584, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Mazestone", "mazestone"), (Object)IEShaderRegister.registerShaderCases("Underbrick", ModType.TWILIGHT_FOREST, "scales", RARITY, -8034235, -9011338, -10400461, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Underbrick", "underbrick"), (Object)IEShaderRegister.registerShaderCases("Ironwood", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -9739935, -10531520, -10594485, -1, (m, t, s, c) -> new ShaderLayer(ModType.TWILIGHT_FOREST.provideTex(t, "streaks"), -8815549), LAYER_PROVIDER).setInfo("Twilight Forest", "Ironwood", "ironwood"), (Object)IEShaderRegister.registerShaderCases("Steeleaf", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -11368646, -14798316, -12492240, -1, (m, t, s, c) -> new ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "1_4"), -12492240), (m, t, s, c) -> new ShaderLayer(ModType.TWILIGHT_FOREST.provideTex(t, "streaks"), -9592226), LAYER_PROVIDER).setInfo("Twilight Forest", "Steeleaf", "steeleaf"), (Object)IEShaderRegister.registerShaderCases("Knightly", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -1573683, -11711413, -8352654, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Knightly", "knightly"), (Object)IEShaderRegister.registerShaderCases("Fiery", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -15133933, -142243, -8964847, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Fiery", "fiery"), (Object)IEShaderRegister.registerShaderCases("Final Castle", ModType.TWILIGHT_FOREST, "scales", RARITY, -1250586, -3621956, -16711681, -16711681, LAYER_PROVIDER).setInfo("Twilight Forest", "Final Castle", "finalcastle"), (Object)IEShaderRegister.registerShaderCases("Cube of Annihilation", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -16777213, -15466432, -16777213, -15466432, (m, t, s, c) -> new ShaderLayer(m.provideTex(t, s), -15466432)).setInfo("Twilight Forest", "Cube of Annilation", "cube_of_annilation"));
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.addAll(NONBOSSES);
        listBuilder.add((Object[])new ShaderRegistry.ShaderRegistryEntry[]{IEShaderRegister.registerShaderCases("Questing Ram", ModType.TWILIGHT_FOREST, "streaks", RARITY, -400952, -6650519, -13685962, -7284497, LAYER_PROVIDER, (m, t, s, c) -> new ShaderConsumerLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "circuit"), 814799087, RAM_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS)).setInfo("Twilight Forest", "Questing Ram", "questing_ram"), IEShaderRegister.registerShaderCases("Naga", ModType.TWILIGHT_FOREST, "scales", RARITY, -13476571, -15259375, -5909482, -1, LAYER_PROVIDER, (m, t, s, c) -> new ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "shark"), -1)).setInfo("Twilight Forest", "Naga Boss", "naga"), IEShaderRegister.registerShaderCases("Lich", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -2106932, -3957760, -12974987, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Twilight Lich Boss", "lich"), IEShaderRegister.registerShaderCases("Minoshroom", ModType.IMMERSIVE_ENGINEERING, "1_6", RARITY, -5763054, -5000269, -13374517, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Minoshroom Miniboss", "minoshroom"), IEShaderRegister.registerShaderCases("Hydra", ModType.TWILIGHT_FOREST, "scales", RARITY, -15455936, -14057365, -980334, -1, LAYER_PROVIDER, (m, t, s, c) -> new ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "shark"), -1)).setInfo("Twilight Forest", "Hydra Boss", "hydra"), IEShaderRegister.registerShaderCases("Knight Phantom", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -868193019, -13224652, -8758199, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Knight Phantom Minibosses", "knight_phantom"), IEShaderRegister.registerShaderCases("Ur-Ghast", ModType.IMMERSIVE_ENGINEERING, "1_2", RARITY, -394759, -6670537, -11119018, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Ur-Ghast", "ur-ghast"), IEShaderRegister.registerShaderCases("Alpha Yeti", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -197380, -11894578, -14336154, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Alpha Yeti", "alpha_yeti"), IEShaderRegister.registerShaderCases("Snow Queen", ModType.IMMERSIVE_ENGINEERING, "1_0", RARITY, -2294785, -3957760, -16579191, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Snow Queen", "snow_queen")});
        SHADERS = listBuilder.build();
    }

    public static List<ShaderRegistry.ShaderRegistryEntry> getAllTwilightShaders() {
        return SHADERS;
    }

    public static List<ShaderRegistry.ShaderRegistryEntry> getAllNonbossShaders() {
        return NONBOSSES;
    }

    @SafeVarargs
    private static ShaderRegistry.ShaderRegistryEntry registerShaderCasesTopped(String name, ModType mod, String overlayType, Rarity rarity, int bodyColor, int colorSecondary, int gripColor, int colorBlade, ShaderLayerProvider<? extends ShaderLayer>[] providers, ShaderLayerProvider<? extends ShaderLayer> ... extraProviders) {
        ResourceLocation modName = new ResourceLocation("twilightforest", name.toLowerCase(Locale.ROOT).replace(" ", "_"));
        ShaderRegistry.registerShader_Item((ResourceLocation)modName, (Rarity)rarity, (int)gripColor, (int)bodyColor, (int)colorSecondary);
        IEShaderRegister.registerShaderCaseRevolver(modName, gripColor, bodyColor, colorBlade, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.REVOLVER, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.REVOLVER, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseChemthrower(modName, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.CHEMICAL_THROWER, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.CHEMICAL_THROWER, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseDrill(modName, gripColor, bodyColor, colorBlade, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.DRILL, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.DRILL, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseRailgun(modName, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.RAILGUN, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.RAILGUN, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseShield(modName, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.SHIELD, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.SHIELD, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseMinecart(modName, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.MINECART, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.MINECART, overlayType + ".png", colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseBalloon(modName, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.BALLOON, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.BALLOON, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseBanner(modName, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.BALLOON, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.BANNER, overlayType, colorSecondary, extraProviders));
        for (ShaderRegistry.IShaderRegistryMethod method : ShaderRegistry.shaderRegistrationMethods) {
            method.apply(modName, overlayType, rarity, gripColor, bodyColor, colorSecondary, colorBlade, null, 0);
        }
        return ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(modName)).setCrateLoot(false).setBagLoot(false).setInLowerBags(false).setReplicationCost(() -> new IngredientWithSize(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)TFItems.ore_meter.get()})));
    }

    @SafeVarargs
    private static ShaderRegistry.ShaderRegistryEntry registerShaderCases(String name, ModType type, String overlayType, Rarity rarity, int bodyColor, int colorSecondary, int gripColor, int colorBlade, ShaderLayerProvider<? extends ShaderLayer> ... providers) {
        return IEShaderRegister.registerShaderCasesTopped(name, type, overlayType, rarity, bodyColor, colorSecondary, gripColor, colorBlade, providers, new ShaderLayerProvider[0]);
    }

    private static ShaderLayer[] provideFromProviders(ModType mod, CaseType type, String suffix, int color, ShaderLayerProvider<? extends ShaderLayer>[] layerProviders) {
        ShaderLayer[] array = new ShaderLayer[layerProviders.length];
        for (int i = 0; i < layerProviders.length; ++i) {
            array[i] = layerProviders[i].get(mod, type, suffix, color);
        }
        return array;
    }

    private static ShaderCaseRevolver registerShaderCaseRevolver(ResourceLocation name, int gripColor, int bodyColor, int bladeColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseRevolver)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new ShaderCaseRevolver((Collection)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(PROCESSED_REVOLVER_GRIP_LAYER, gripColor), new ShaderLayer(PROCESSED_REVOLVER_LAYER, bodyColor), new ShaderLayer(PROCESSED_REVOLVER_LAYER, bladeColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_REVOLVER_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    private static ShaderCaseChemthrower registerShaderCaseChemthrower(ResourceLocation name, int gripColor, int bodyColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseChemthrower)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new TFShaderCaseChemthrower(3 + additionalLayers.length, (Collection<ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(PROCESSED_CHEMTHROW_LAYER, gripColor), new ShaderLayer(PROCESSED_CHEMTHROW_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_CHEMTHROW_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    private static ShaderCaseDrill registerShaderCaseDrill(ResourceLocation name, int gripColor, int bodyColor, int bladeColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseDrill)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new TFShaderCaseDrill(5 + additionalLayers.length, (Collection<ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(PROCESSED_DRILL_LAYER, gripColor), new ShaderLayer(PROCESSED_DRILL_LAYER, bodyColor)}).add((Object)UNCOLORED_DRILL_LAYER).add((Object[])additionalLayers).add((Object)UNCOLORED_DRILL_LAYER).add((Object)NULL_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    private static ShaderCaseRailgun registerShaderCaseRailgun(ResourceLocation name, int gripColor, int bodyColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseRailgun)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new TFShaderCaseRailgun(3 + additionalLayers.length, (Collection<ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(PROCESSED_RAILGUN_LAYER, gripColor), new ShaderLayer(PROCESSED_RAILGUN_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_RAILGUN_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    private static ShaderCaseShield registerShaderCaseShield(ResourceLocation name, int gripColor, int bodyColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseShield)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new TFShaderCaseShield(3 + additionalLayers.length, (Collection<ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(PROCESSED_SHIELD_LAYER, gripColor), new ShaderLayer(PROCESSED_SHIELD_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_SHIELD_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    private static ShaderCaseMinecart registerShaderCaseMinecart(ResourceLocation name, int bodyColor, int secondaryColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseMinecart)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new ShaderCaseMinecart((Collection)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(new ResourceLocation("immersiveengineering", "textures/models/shaders/minecart_0.png"), bodyColor), new ShaderLayer(new ResourceLocation("immersiveengineering", "textures/models/shaders/minecart_1_0.png"), secondaryColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_MINECART_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    public static ShaderCaseBanner registerShaderCaseBanner(ResourceLocation name, int bodyColor, int secondaryColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseBanner)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new ShaderCaseBanner((Collection)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(new ResourceLocation("immersiveengineering", "block/shaders/banner_0"), bodyColor), new ShaderLayer(new ResourceLocation("immersiveengineering", "block/shaders/banner_1_0"), secondaryColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_BANNER_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    private static ShaderCaseBalloon registerShaderCaseBalloon(ResourceLocation name, int gripColor, int bodyColor, Rarity rarity, ShaderLayer[] additionalLayers, ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseBalloon)ShaderRegistry.registerShaderCase((ResourceLocation)name, (ShaderCase)new ShaderCaseBalloon((Collection)shaderLayerBuilder.add((Object[])new ShaderLayer[]{new ShaderLayer(PROCESSED_BALLOON_LAYER, gripColor), new ShaderLayer(PROCESSED_BALLOON_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_BALLOON_LAYER).add((Object[])topLayers).build()), (Rarity)rarity);
    }

    static {
        RARITY = TwilightForestMod.getRarity();
    }

    public static enum CaseType {
        REVOLVER,
        CHEMICAL_THROWER,
        DRILL,
        RAILGUN,
        SHIELD,
        MINECART,
        BALLOON,
        BANNER;


        public static CaseType[] everythingButMinecart() {
            return new CaseType[]{REVOLVER, CHEMICAL_THROWER, DRILL, RAILGUN, SHIELD, BALLOON, BANNER};
        }
    }

    public static enum ModType {
        IMMERSIVE_ENGINEERING("immersiveengineering"){

            @Override
            String getPath(CaseType caseType, String suffix) {
                switch (caseType) {
                    case REVOLVER: {
                        return "revolvers/shaders/revolver_" + suffix;
                    }
                    case CHEMICAL_THROWER: {
                        return "item/shaders/chemthrower_" + suffix;
                    }
                    case DRILL: {
                        return "item/shaders/drill_diesel_" + suffix;
                    }
                    case RAILGUN: {
                        return "item/shaders/railgun_" + suffix;
                    }
                    case SHIELD: {
                        return "item/shaders/shield_" + suffix;
                    }
                    case MINECART: {
                        return "textures/models/shaders/minecart_" + suffix + ".png";
                    }
                    case BALLOON: {
                        return "block/shaders/balloon_" + suffix;
                    }
                    case BANNER: {
                        return "block/shaders/banner_" + suffix;
                    }
                }
                return "";
            }
        }
        ,
        TWILIGHT_FOREST("twilightforest"){

            @Override
            String getPath(CaseType caseType, String suffix) {
                switch (caseType) {
                    case REVOLVER: {
                        return "items/immersiveengineering/revolver_" + suffix;
                    }
                    case CHEMICAL_THROWER: {
                        return "items/immersiveengineering/chemthrower_" + suffix;
                    }
                    case DRILL: {
                        return "items/immersiveengineering/drill_" + suffix;
                    }
                    case RAILGUN: {
                        return "items/immersiveengineering/railgun_" + suffix;
                    }
                    case SHIELD: {
                        return "items/immersiveengineering/shield_" + suffix;
                    }
                    case MINECART: {
                        return "textures/model/immersiveengineering/minecart_" + suffix + ".png";
                    }
                    case BALLOON: {
                        return "block/immersiveengineering/balloon_" + suffix;
                    }
                    case BANNER: {
                        return "block/immersiveengineering/banner_" + suffix;
                    }
                }
                return "";
            }

            @Override
            public ResourceLocation provideTex(CaseType caseType, String suffix) {
                if (caseType == CaseType.MINECART && suffix.startsWith("1_")) {
                    return IMMERSIVE_ENGINEERING.provideTex(caseType, suffix);
                }
                return super.provideTex(caseType, suffix);
            }
        };

        private final String namespace;

        private ModType(String namespace) {
            this.namespace = namespace;
        }

        abstract String getPath(CaseType var1, String var2);

        public ResourceLocation provideTex(CaseType caseType, String suffix) {
            return new ResourceLocation(this.namespace, this.getPath(caseType, suffix));
        }
    }

    @FunctionalInterface
    private static interface ShaderLayerProvider<T extends ShaderLayer> {
        public T get(ModType var1, CaseType var2, String var3, int var4);
    }

    private static class ShaderConsumerLayer
    extends DynamicShaderLayer {
        private final BiConsumer<IntConsumer, Boolean> render;
        private final IntConsumer shaderCallback;

        ShaderConsumerLayer(ResourceLocation texture, int colour, BiConsumer<IntConsumer, Boolean> render, ShaderUniform[] shaderParams) {
            super(texture, colour);
            this.render = render;
            this.shaderCallback = shader -> {
                for (ShaderUniform param : shaderParams) {
                    param.assignUniform(shader);
                }
            };
        }

        @OnlyIn(value=Dist.CLIENT)
        public RenderType getRenderType(RenderType baseType) {
            if (this.render == null) {
                return baseType;
            }
            return new RenderType("shader_" + baseType + this.render, DefaultVertexFormats.field_176600_a, 7, 256, false, true, () -> {
                baseType.func_228547_a_();
                this.render.accept(this.shaderCallback, true);
            }, () -> {
                this.render.accept(this.shaderCallback, false);
                baseType.func_228549_b_();
            }){};
        }
    }
}

