/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.NagaModel;
import twilightforest.entity.boss.NagaEntity;

public class NagaRenderer<M extends NagaModel<NagaEntity>>
extends MobRenderer<NagaEntity, M> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("nagahead.png");
    private static final ResourceLocation textureLocDazed = TwilightForestMod.getModelTexture("nagahead_dazed.png");
    private static final ResourceLocation textureLocCharging = TwilightForestMod.getModelTexture("nagahead_charge.png");

    public NagaRenderer(EntityRendererManager manager, M modelbase, float shadowSize) {
        super(manager, modelbase, shadowSize);
    }

    public void render(NagaEntity entity, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        super.func_225623_a_((MobEntity)entity, entityYaw, partialTicks, stack, buffer, light);
        if (!Minecraft.func_71410_x().func_147113_T() && entity.isDazed()) {
            Vector3d pos = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + 3.15, entity.func_226281_cx_()).func_178787_e(new Vector3d(1.5, 0.0, 0.0).func_178785_b((float)Math.toRadians(entity.func_70681_au().nextInt(360))));
            Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197614_g, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    public ResourceLocation getEntityTexture(NagaEntity entity) {
        if (entity.isDazed()) {
            return textureLocDazed;
        }
        if (entity.isCharging()) {
            return textureLocCharging;
        }
        return textureLoc;
    }
}

