/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFHorizontalBlock;
import twilightforest.enums.NagastoneVariant;

public class NagastoneBlock
extends Block {
    public static final EnumProperty<NagastoneVariant> VARIANT = EnumProperty.func_177709_a((String)"variant", NagastoneVariant.class);

    public NagastoneBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(VARIANT, (Comparable)((Object)NagastoneVariant.SOLID)));
    }

    public BlockState func_196271_a(BlockState state, Direction directionToNeighbor, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        return this.getVariant(world, pos);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getVariant((IWorld)ctx.func_195991_k(), ctx.func_195995_a());
    }

    private BlockState getVariant(IWorld world, BlockPos pos) {
        BlockState stateOut;
        int connectionCount = 0;
        Direction[] facings = new Direction[2];
        for (Direction side : Direction.values()) {
            BlockState neighborState = world.func_180495_p(pos.func_177972_a(side));
            if (neighborState.func_177230_c() != this && (neighborState.func_177230_c() != TFBlocks.naga_stone_head.get() || side != neighborState.func_177229_b((Property)TFHorizontalBlock.field_185512_D))) continue;
            facings[connectionCount++] = side;
            if (connectionCount >= 2) break;
        }
        switch (connectionCount) {
            case 1: {
                facings[1] = facings[0];
            }
            case 2: {
                stateOut = (BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)NagastoneVariant.getVariantFromDoubleFacing(facings[0], facings[1])));
                break;
            }
            default: {
                stateOut = this.func_176223_P();
            }
        }
        return stateOut;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VARIANT});
    }
}

