/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.environmental;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class MobRepulsorModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.ENVIRONMENTAL, ModuleTarget.TORSOONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("mobRepulsorEnergy", 2500.0, "FE");
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack item) {
                int energyConsumption = (int)this.applyPropertyModifiers("mobRepulsorEnergy");
                if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > energyConsumption) {
                    if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)energyConsumption);
                    }
                    this.repulse(player.field_70170_p, player.func_233580_cy_());
                }
            }

            public void repulse(World world, BlockPos playerPos) {
                float distance = 5.0f;
                AxisAlignedBB area = new AxisAlignedBB(playerPos.func_177963_a((double)(-distance), (double)(-distance), (double)(-distance)), playerPos.func_177963_a((double)distance, (double)distance, (double)distance));
                for (Entity entity : world.func_217357_a(MobEntity.class, area)) {
                    this.push(entity, playerPos);
                }
                for (Entity entity : world.func_217357_a(ArrowEntity.class, area)) {
                    this.push(entity, playerPos);
                }
                for (Entity entity : world.func_217357_a(FireballEntity.class, area)) {
                    this.push(entity, playerPos);
                }
                for (Entity entity : world.func_217357_a(PotionEntity.class, area)) {
                    this.push(entity, playerPos);
                }
            }

            private void push(Entity entity, BlockPos playerPos) {
                if (!(entity instanceof PlayerEntity) && !(entity instanceof EnderDragonEntity)) {
                    BlockPos distance = playerPos.func_177973_b((Vector3i)entity.func_233580_cy_());
                    double dX = distance.func_177958_n();
                    double dY = distance.func_177956_o();
                    double dZ = distance.func_177952_p();
                    double d4 = dX * dX + dY * dY + dZ * dZ;
                    if ((d4 *= d4) <= Math.pow(6.0, 4.0)) {
                        double d5 = -(dX * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                        double d6 = -(dY * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                        double d7 = -(dZ * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                        if (d5 > 0.0) {
                            d5 = 0.22;
                        } else if (d5 < 0.0) {
                            d5 = -0.22;
                        }
                        if (d6 > 0.2) {
                            d6 = 0.12;
                        } else if (d6 < -0.1) {
                            d6 = 0.12;
                        }
                        if (d7 > 0.0) {
                            d7 = 0.22;
                        } else if (d7 < 0.0) {
                            d7 = -0.22;
                        }
                        Vector3d motion = entity.func_213322_ci();
                        entity.func_213293_j(motion.field_72450_a + d5, motion.field_72448_b + d6, motion.field_72449_c + d7);
                    }
                }
            }
        }
    }
}

